/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.EncryptionKeyImpl;
import com.dstc.security.kerberos.KerberosException;
import java.util.Date;
import java.util.Iterator;

final class EncAPRepPart {
    public static final int TAG_KRB_ENC_AP_REP_PART = 27;
    private Asn1 asn1 = null;
    private Date ctime;
    private int cusec;
    private EncryptionKeyImpl key = null;
    private int seqNum = -1;

    EncAPRepPart(Asn1 asn1) throws Asn1Exception, KerberosException {
        this.asn1 = asn1;
        if (this.asn1.getTagNumber() != 27) {
            throw new KerberosException("Wrong tag for an EncAPRepPart");
        }
        Iterator iterator = ((Sequence)asn1.components().next()).components();
        Asn1 asn12 = (Asn1)iterator.next();
        this.ctime = ((GeneralizedTime)asn12.components().next()).getDate();
        asn12 = (Asn1)iterator.next();
        this.cusec = ((Integer)asn12.components().next()).getInt();
        if (!iterator.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 2) {
            this.key = new EncryptionKeyImpl((Asn1)asn12.components().next());
            if (!iterator.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 3) {
            this.seqNum = ((Integer)asn12.components().next()).getInt();
        }
    }

    EncAPRepPart(Date date, int n, EncryptionKeyImpl encryptionKeyImpl, int n2) {
        this.asn1 = new Explicit(64, 27);
        Sequence sequence = new Sequence();
        long l = date.getTime();
        long l2 = l / 1000L * 1000L;
        this.ctime = new Date(l2);
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new GeneralizedTime(date));
        sequence.add(explicit);
        int n3 = n - n / 1000 * 1000;
        this.cusec = (int)((l - l2) * 1000L) + n3;
        explicit = new Explicit(128, 1);
        explicit.add(new Integer(n));
        sequence.add(explicit);
        this.key = encryptionKeyImpl;
        if (encryptionKeyImpl != null) {
            explicit = new Explicit(128, 2);
            explicit.add(encryptionKeyImpl.getAsn1());
            sequence.add(explicit);
        }
        this.seqNum = n2;
        if (n2 != -1) {
            explicit = new Explicit(128, 3);
            explicit.add(new Integer(n2));
            sequence.add(explicit);
        }
        this.asn1.add(sequence);
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    Date getClientTime() {
        return new Date(this.ctime.getTime() + (long)(this.cusec / 1000));
    }

    int getCusec() {
        return this.cusec;
    }

    EncryptionKeyImpl getEncryptionKey() {
        return this.key;
    }

    int getSequenceNumber() {
        return this.seqNum;
    }
}

