/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.EncryptionKeyImpl;
import com.dstc.security.kerberos.HostAddress;
import com.dstc.security.kerberos.LastReqElement;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.TicketFlagsImpl;
import java.net.InetAddress;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

final class EncKDCRepPart {
    private Asn1 asn1 = null;
    private EncryptionKeyImpl key = null;
    private Vector lastReq = null;
    private int nonce;
    private Date keyExp = null;
    private TicketFlagsImpl flags = null;
    private Date authtime = null;
    private Date starttime = null;
    private Date endtime = null;
    private Date renewTill = null;
    private String srealm = null;
    private PrincipalName sname = null;
    private Vector caddr = null;

    EncKDCRepPart(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        this.key = new EncryptionKeyImpl((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator.next();
        this.lastReq = new Vector();
        Iterator iterator2 = ((Sequence)asn12.components().next()).components();
        while (iterator2.hasNext()) {
            this.lastReq.add(new LastReqElement((Asn1)iterator2.next()));
        }
        asn12 = (Asn1)iterator.next();
        this.nonce = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 3) {
            this.keyExp = ((GeneralizedTime)asn12.components().next()).getDate();
            asn12 = (Asn1)iterator.next();
        }
        this.flags = new TicketFlagsImpl((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator.next();
        this.authtime = ((GeneralizedTime)asn12.components().next()).getDate();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 6) {
            this.starttime = ((GeneralizedTime)asn12.components().next()).getDate();
            asn12 = (Asn1)iterator.next();
        }
        this.endtime = ((GeneralizedTime)asn12.components().next()).getDate();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 8) {
            this.renewTill = ((GeneralizedTime)asn12.components().next()).getDate();
            asn12 = (Asn1)iterator.next();
        }
        this.srealm = ((GeneralString)asn12.components().next()).getString();
        asn12 = (Asn1)iterator.next();
        this.sname = new PrincipalName((Asn1)asn12.components().next());
        if (!iterator.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator.next();
        this.caddr = new Vector();
        Iterator iterator3 = ((Sequence)asn12.components().next()).components();
        while (iterator3.hasNext()) {
            this.caddr.add(new HostAddress((Asn1)iterator3.next()).getInetAddress());
        }
    }

    EncKDCRepPart(EncryptionKeyImpl encryptionKeyImpl, Vector vector, int n, Date date, TicketFlagsImpl ticketFlagsImpl, Date date2, Date date3, Date date4, Date date5, String string, PrincipalName principalName, Vector vector2) {
        this.asn1 = new Sequence();
        this.key = encryptionKeyImpl;
        Explicit explicit = new Explicit(128, 0);
        explicit.add(this.key.getAsn1());
        this.asn1.add(explicit);
        this.lastReq = vector;
        explicit = new Explicit(128, 1);
        Sequence sequence = new Sequence();
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            sequence.add(((LastReqElement)iterator.next()).getAsn1());
        }
        explicit.add(sequence);
        this.asn1.add(explicit);
        this.nonce = n;
        explicit = new Explicit(128, 2);
        explicit.add(new Integer(n));
        this.asn1.add(explicit);
        if (date != null) {
            this.keyExp = date;
            explicit = new Explicit(128, 3);
            explicit.add(new GeneralizedTime(date));
            this.asn1.add(explicit);
        }
        this.flags = ticketFlagsImpl;
        explicit = new Explicit(128, 4);
        explicit.add(ticketFlagsImpl.getAsn1());
        this.asn1.add(explicit);
        this.authtime = date2;
        explicit = new Explicit(128, 5);
        explicit.add(new GeneralizedTime(date2));
        this.asn1.add(explicit);
        if (date3 != null) {
            this.starttime = date3;
            explicit = new Explicit(128, 6);
            explicit.add(new GeneralizedTime(date3));
            this.asn1.add(explicit);
        }
        this.endtime = date4;
        explicit = new Explicit(128, 7);
        explicit.add(new GeneralizedTime(date4));
        this.asn1.add(explicit);
        if (date5 != null) {
            this.renewTill = date5;
            explicit = new Explicit(128, 8);
            explicit.add(new GeneralizedTime(date5));
            this.asn1.add(explicit);
        }
        this.srealm = string;
        explicit = new Explicit(128, 9);
        explicit.add(new GeneralString(string));
        this.asn1.add(explicit);
        this.sname = principalName;
        explicit = new Explicit(128, 10);
        explicit.add(principalName.getAsn1());
        this.asn1.add(explicit);
        if (vector2 != null) {
            this.caddr = vector2;
            explicit = new Explicit(128, 11);
            Sequence sequence2 = new Sequence();
            Iterator iterator2 = ((AbstractList)vector2).iterator();
            while (iterator2.hasNext()) {
                sequence2.add(new HostAddress((InetAddress)iterator2.next()).getAsn1());
            }
            explicit.add(sequence2);
            this.asn1.add(explicit);
        }
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    Date getAuthTime() {
        return this.authtime;
    }

    Vector getClientAddresses() {
        return this.caddr;
    }

    EncryptionKeyImpl getEncryptionKey() {
        return this.key;
    }

    Date getEndTime() {
        return this.endtime;
    }

    Date getKeyExpiryTime() {
        return this.keyExp;
    }

    Vector getLastReq() {
        return this.lastReq;
    }

    int getNonce() {
        return this.nonce;
    }

    Date getRenewTill() {
        return this.renewTill;
    }

    PrincipalName getServerName() {
        return this.sname;
    }

    String getServerRealm() {
        return this.srealm;
    }

    Date getStartTime() {
        return this.starttime;
    }

    TicketFlagsImpl getTicketFlags() {
        return this.flags;
    }
}

