/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.AuthDataElement;
import com.dstc.security.kerberos.AuthorizationDataElement;
import com.dstc.security.kerberos.EncryptionKeyImpl;
import com.dstc.security.kerberos.HostAddress;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.TicketFlagsImpl;
import com.dstc.security.kerberos.TransitedEncoding;
import java.net.InetAddress;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

final class EncTicketPart {
    public static final int TAG_KRB_ENC_TICKET = 3;
    private Asn1 asn1 = null;
    private TicketFlagsImpl ticketFlags;
    private EncryptionKeyImpl key;
    private String crealm;
    private PrincipalName cname;
    private TransitedEncoding transited;
    private Date authtime;
    private Date starttime;
    private Date endtime;
    private Date renewTill;
    private Vector caddr;
    private Vector authData;

    EncTicketPart(Asn1 asn1) throws Asn1Exception {
        Iterator iterator;
        this.asn1 = asn1;
        if (asn1.getTagNumber() != 3) {
            throw new Asn1Exception("Wrong Tag number for EncTicketPart");
        }
        Iterator iterator2 = ((Sequence)asn1.components().next()).components();
        Asn1 asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag Number");
        }
        this.ticketFlags = new TicketFlagsImpl((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.key = new EncryptionKeyImpl((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() != 2) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.crealm = ((GeneralString)asn12.components().next()).getString();
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() != 3) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.cname = new PrincipalName((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() != 4) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.transited = new TransitedEncoding((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() != 5) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.authtime = ((GeneralizedTime)asn12.components().next()).getDate();
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() == 6) {
            this.starttime = ((GeneralizedTime)asn12.components().next()).getDate();
            asn12 = (Asn1)iterator2.next();
        }
        if (asn12.getTagNumber() != 7) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.endtime = ((GeneralizedTime)asn12.components().next()).getDate();
        if (!iterator2.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() == 8) {
            this.renewTill = ((GeneralizedTime)asn12.components().next()).getDate();
            if (!iterator2.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator2.next();
        }
        if (asn12.getTagNumber() == 9) {
            this.caddr = new Vector();
            iterator = ((Sequence)asn12.components().next()).components();
            while (iterator.hasNext()) {
                this.caddr.add(new HostAddress((Asn1)iterator.next()).getInetAddress());
            }
            if (!iterator2.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator2.next();
        }
        if (asn12.getTagNumber() == 10) {
            this.authData = new Vector();
            iterator = ((Sequence)asn12.components().next()).components();
            while (iterator.hasNext()) {
                this.authData.add(new AuthDataElement((Asn1)iterator.next()));
            }
        }
    }

    EncTicketPart(TicketFlagsImpl ticketFlagsImpl, EncryptionKeyImpl encryptionKeyImpl, String string, PrincipalName principalName, TransitedEncoding transitedEncoding, Date date, Date date2, Date date3, Date date4, Vector vector, Vector vector2) {
        Iterator iterator;
        Sequence sequence;
        this.asn1 = new Explicit(64, 3);
        Sequence sequence2 = new Sequence();
        this.ticketFlags = ticketFlagsImpl;
        Explicit explicit = new Explicit(128, 0);
        explicit.add(ticketFlagsImpl.getAsn1());
        sequence2.add(explicit);
        this.key = encryptionKeyImpl;
        explicit = new Explicit(128, 1);
        explicit.add(encryptionKeyImpl.getAsn1());
        sequence2.add(explicit);
        this.crealm = string;
        explicit = new Explicit(128, 2);
        explicit.add(new GeneralString(string));
        sequence2.add(explicit);
        this.cname = principalName;
        explicit = new Explicit(128, 3);
        explicit.add(principalName.getAsn1());
        sequence2.add(explicit);
        this.transited = transitedEncoding;
        explicit = new Explicit(128, 4);
        explicit.add(transitedEncoding.getAsn1());
        sequence2.add(explicit);
        this.authtime = date;
        explicit = new Explicit(128, 5);
        explicit.add(new GeneralizedTime(date));
        sequence2.add(explicit);
        if (date2 != null) {
            this.starttime = date2;
            explicit = new Explicit(128, 6);
            explicit.add(new GeneralizedTime(date2));
            sequence2.add(explicit);
        }
        this.endtime = date3;
        explicit = new Explicit(128, 7);
        explicit.add(new GeneralizedTime(date3));
        sequence2.add(explicit);
        if (date4 != null) {
            this.renewTill = date4;
            explicit = new Explicit(128, 8);
            explicit.add(new GeneralizedTime(date4));
            sequence2.add(explicit);
        }
        if (vector != null) {
            this.caddr = vector;
            explicit = new Explicit(128, 9);
            sequence = new Sequence();
            iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                sequence.add(new HostAddress((InetAddress)iterator.next()).getAsn1());
            }
            explicit.add(sequence);
            sequence2.add(explicit);
        }
        if (vector2 != null) {
            this.authData = vector2;
            explicit = new Explicit(128, 10);
            sequence = new Sequence();
            iterator = ((AbstractList)vector2).iterator();
            while (iterator.hasNext()) {
                AuthorizationDataElement authorizationDataElement = (AuthorizationDataElement)iterator.next();
                sequence.add(new AuthDataElement(authorizationDataElement.type(), authorizationDataElement.data()).getAsn1());
            }
            explicit.add(sequence);
            sequence2.add(explicit);
        }
        this.asn1.add(sequence2);
    }

    public Vector getAuthData() {
        return this.authData;
    }

    public Date getAuthTime() {
        return this.authtime;
    }

    public Vector getClientAddresses() {
        return this.caddr;
    }

    public PrincipalName getClientName() {
        return this.cname;
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public Date getEndTime() {
        return this.endtime;
    }

    public EncryptionKeyImpl getKey() {
        return this.key;
    }

    public String getRealm() {
        return this.crealm;
    }

    public Date getRenewTill() {
        return this.renewTill;
    }

    public Date getStartTime() {
        return this.starttime;
    }

    public TicketFlagsImpl getTicketFlags() {
        return this.ticketFlags;
    }

    public TransitedEncoding getTransited() {
        return this.transited;
    }
}

