/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.EncryptedData;
import com.dstc.security.kerberos.KerberosException;
import java.util.Iterator;

final class EncryptedDataImpl
extends EncryptedData {
    private Asn1 asn1 = null;
    private int eType;
    private int kvno;
    private byte[] cipherText;

    public EncryptedDataImpl(int n, int n2, byte[] byArray) {
        this.asn1 = new Sequence();
        this.eType = n;
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(n));
        this.asn1.add(explicit);
        if (n2 != -1) {
            this.kvno = n2;
            explicit = new Explicit(128, 1);
            explicit.add(new Integer(n2));
            this.asn1.add(explicit);
        }
        this.cipherText = byArray;
        explicit = new Explicit(128, 2);
        explicit.add(new OctetString(byArray));
        this.asn1.add(explicit);
    }

    public EncryptedDataImpl(int n, byte[] byArray) {
        this(n, -1, byArray);
    }

    public EncryptedDataImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 0) {
            this.eType = ((Integer)asn12.components().next()).getInt();
        }
        if ((asn12 = (Asn1)iterator.next()).getTagNumber() == 1) {
            this.kvno = ((Integer)asn12.components().next()).getInt();
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 2) {
            this.cipherText = ((OctetString)asn12.components().next()).getBytes();
        }
    }

    public EncryptedDataImpl(byte[] byArray) throws Asn1Exception {
        this(Asn1.getAsn1(byArray));
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getCipherText() {
        return this.cipherText;
    }

    public byte[] getEncoded() throws KerberosException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public int getEncryptionType() {
        return this.eType;
    }

    public int getKeyVersionNumber() {
        return this.kvno;
    }
}

