/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;

final class HostAddress {
    public static final int INET = 2;
    private Asn1 asn1 = null;
    private int addressType = 2;
    private InetAddress address;

    HostAddress(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.addressType = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        try {
            this.address = InetAddress.getByName(HostAddress.ipToString(((OctetString)asn12.components().next()).getBytes()));
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException.getMessage());
        }
    }

    HostAddress(InetAddress inetAddress) {
        this.address = inetAddress;
        this.asn1 = new Sequence();
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(this.addressType));
        this.asn1.add(explicit);
        explicit = new Explicit(128, 1);
        explicit.add(new OctetString(inetAddress.getAddress()));
        this.asn1.add(explicit);
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    InetAddress getInetAddress() {
        return this.address;
    }

    static final String ipToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(byArray[0] & 0xFF));
        int n = 1;
        while (n < byArray.length) {
            stringBuffer.append(".").append(String.valueOf(byArray[n] & 0xFF));
            ++n;
        }
        return stringBuffer.toString();
    }
}

