/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;

public class KDCOptions {
    public static final int DISABLE_TRANSITED_CHECK = 32;
    public static final int RENEWABLE_OK = 16;
    public static final int ENC_TKT_IN_SKEY = 8;
    public static final int RENEW = 2;
    public static final int VALIDATE = 1;
    private Asn1 asn1 = null;
    private byte[] contents;

    public KDCOptions() {
        this.contents = new byte[4];
    }

    KDCOptions(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        this.contents = ((BitString)asn1).getBytes();
    }

    public boolean allowPostdate() {
        return (this.contents[0] & 4) != 0;
    }

    public boolean encTicketInSessionKey() {
        return (this.contents[3] & 8) != 0;
    }

    void encode() {
        this.asn1 = new BitString(this.contents);
    }

    public boolean forwardable() {
        return (this.contents[0] & 0x40) != 0;
    }

    public boolean forwarded() {
        return (this.contents[0] & 0x20) != 0;
    }

    Asn1 getAsn1() {
        if (this.asn1 == null) {
            this.encode();
        }
        return this.asn1;
    }

    public boolean postdated() {
        return (this.contents[0] & 2) != 0;
    }

    public boolean proxiable() {
        return (this.contents[0] & 0x10) != 0;
    }

    public boolean proxy() {
        return (this.contents[0] & 8) != 0;
    }

    public boolean renewable() {
        return (this.contents[1] & 0xFFFFFF80) != 0;
    }

    public void reset() {
        int n = 0;
        while (n < 4) {
            this.contents[n] = 0;
            ++n;
        }
        this.asn1 = null;
    }

    public void setAllowPostdate() {
        this.contents[0] = (byte)(this.contents[0] | 4);
        this.asn1 = null;
    }

    public void setEncTicketInSessionKey() {
        this.contents[3] = (byte)(this.contents[3] | 8);
        this.asn1 = null;
    }

    public void setForwardable() {
        this.contents[0] = (byte)(this.contents[0] | 0x40);
        this.asn1 = null;
    }

    public void setForwarded() {
        this.contents[0] = (byte)(this.contents[0] | 0x20);
        this.asn1 = null;
    }

    public void setPostdated() {
        this.contents[0] = (byte)(this.contents[0] | 2);
        this.asn1 = null;
    }

    public void setProxiable() {
        this.contents[0] = (byte)(this.contents[0] | 0x10);
        this.asn1 = null;
    }

    public void setProxy() {
        this.contents[0] = (byte)(this.contents[0] | 8);
        this.asn1 = null;
    }

    public void setRenewable() {
        this.contents[1] = (byte)(this.contents[1] | 0xFFFFFF80);
        this.asn1 = null;
    }
}

