/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.EncryptedDataImpl;
import com.dstc.security.kerberos.EncryptionType;
import com.dstc.security.kerberos.KDCOptions;
import com.dstc.security.kerberos.KDCReqBody;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.PaData;
import com.dstc.security.kerberos.PaDataImpl;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.Ticket;
import java.net.InetAddress;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

class KDCReqImpl {
    private Asn1 asn1 = null;
    private int pvno = 5;
    private int msgType;
    private Vector paDatas;
    private KDCReqBody reqBody;
    private KDCOptions kdcOptions = null;
    private PrincipalName cname;
    private String realm;
    private PrincipalName sname;
    private Date from = null;
    private Date till = null;
    private Date rtime = null;
    private int nonce = -1;
    private EncryptionType etype = null;
    private Vector adds = null;
    private EncryptedDataImpl encAuthData = null;
    private Vector addTickets = null;

    KDCReqImpl(int n) {
        this.msgType = n;
    }

    KDCReqImpl(Asn1 asn1) throws Asn1Exception, KerberosException {
        this.asn1 = asn1;
        Sequence sequence = (Sequence)asn1.components().next();
        Iterator iterator = sequence.components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (((Integer)asn12.components().next()).getInt() != this.pvno) {
            throw new KerberosException("Bad version number");
        }
        asn12 = (Asn1)iterator.next();
        this.msgType = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 3) {
            this.paDatas = new Vector();
            Iterator iterator2 = ((Sequence)asn12.components().next()).components();
            while (iterator2.hasNext()) {
                this.paDatas.add(new PaDataImpl((Asn1)iterator2.next()));
            }
            asn12 = (Asn1)iterator.next();
        }
        this.reqBody = new KDCReqBody((Asn1)asn12.components().next());
        this.kdcOptions = this.reqBody.getOptions();
        this.cname = this.reqBody.getClientName();
        this.realm = this.reqBody.getRealm();
        this.sname = this.reqBody.getServerName();
        this.from = this.reqBody.getFrom();
        this.till = this.reqBody.getTill();
        this.rtime = this.reqBody.getRenewTill();
        this.nonce = this.reqBody.getNonce();
        this.etype = this.reqBody.getEncryptionType();
        this.adds = this.reqBody.getClientAddresses();
        this.encAuthData = this.reqBody.getEncAuthData();
        this.addTickets = this.reqBody.getAdditionalTickets();
    }

    void addAddress(InetAddress inetAddress) {
        if (this.adds == null) {
            this.adds = new Vector();
        }
        this.adds.add(inetAddress);
    }

    void addPaData(PaData paData) {
        if (this.paDatas == null) {
            this.paDatas = new Vector();
        }
        this.paDatas.add(paData);
    }

    void addTicket(Ticket ticket) {
        if (this.addTickets == null) {
            this.addTickets = new Vector();
        }
        this.addTickets.add(ticket);
    }

    void encode() throws KerberosException {
        this.asn1 = new Explicit(64, this.msgType);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(128, 1);
        explicit.add(new Integer(this.pvno));
        sequence.add(explicit);
        explicit = new Explicit(128, 2);
        explicit.add(new Integer(this.msgType));
        sequence.add(explicit);
        if (this.paDatas != null) {
            Iterator iterator = ((AbstractList)this.paDatas).iterator();
            Sequence sequence2 = new Sequence();
            while (iterator.hasNext()) {
                PaData paData = (PaData)iterator.next();
                sequence2.add(new PaDataImpl(paData.type(), paData.value()).getAsn1());
            }
            explicit = new Explicit(128, 3);
            explicit.add(sequence2);
            sequence.add(explicit);
        }
        this.setKDCReqBody();
        explicit = new Explicit(128, 4);
        explicit.add(this.reqBody.getAsn1());
        sequence.add(explicit);
        this.asn1.add(sequence);
    }

    public Ticket[] getAdditionalTickets() {
        if (this.addTickets == null) {
            return null;
        }
        Ticket[] ticketArray = new Ticket[this.addTickets.size()];
        this.addTickets.toArray(ticketArray);
        return ticketArray;
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public InetAddress[] getClientAddresses() {
        if (this.adds == null) {
            return null;
        }
        InetAddress[] inetAddressArray = new InetAddress[this.adds.size()];
        this.adds.toArray(inetAddressArray);
        return inetAddressArray;
    }

    public PrincipalName getClientName() {
        return this.cname;
    }

    public byte[] getEncoded() throws KerberosException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    byte[] getEncodedBody() throws KerberosException {
        if (this.reqBody == null) {
            throw new KerberosException("KDCReqBody not yet set");
        }
        try {
            return this.reqBody.getAsn1().getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public int[] getEncryptionType() {
        return this.etype.getTypes();
    }

    public Date getEndTime() {
        return this.till;
    }

    int getMsgType() {
        return this.msgType;
    }

    public int getNonce() {
        return this.nonce;
    }

    public KDCOptions getOptions() {
        return this.kdcOptions;
    }

    public PaData[] getPaDatas() {
        if (this.paDatas == null) {
            return null;
        }
        PaData[] paDataArray = new PaData[this.paDatas.size()];
        this.paDatas.toArray(paDataArray);
        return paDataArray;
    }

    public String getRealm() {
        return this.realm;
    }

    public Date getRenewTill() {
        return this.rtime;
    }

    public PrincipalName getServerName() {
        return this.sname;
    }

    public Date getStartTime() {
        return this.from;
    }

    void setClientName(PrincipalName principalName) {
        this.cname = new PrincipalName(principalName.nameType(), principalName.nameComponents());
    }

    void setEncAuthData(EncryptedDataImpl encryptedDataImpl) {
        this.encAuthData = encryptedDataImpl;
    }

    void setEncryptionType(EncryptionType encryptionType) {
        this.etype = encryptionType;
    }

    void setEndTime(Date date) {
        this.till = date;
    }

    void setKDCOptions(KDCOptions kDCOptions) {
        this.kdcOptions = kDCOptions;
    }

    void setKDCReqBody() throws KerberosException {
        this.reqBody = new KDCReqBody(this.kdcOptions, this.cname, this.realm, this.sname, this.from, this.till, this.rtime, this.nonce, this.etype, this.adds, this.encAuthData, this.addTickets);
    }

    void setMsgType(int n) {
        this.msgType = n;
    }

    void setNonce(int n) {
        this.nonce = n;
    }

    void setRealm(String string) {
        this.realm = string;
    }

    void setRenewTill(Date date) {
        this.rtime = date;
    }

    void setServerName(PrincipalName principalName) {
        this.sname = new PrincipalName(principalName.nameType(), principalName.nameComponents());
    }

    void setStartTime(Date date) {
        this.from = date;
    }

    void setTicketValidity(int n) {
        this.till = new Date(System.currentTimeMillis() + (long)(3600000 * n));
    }
}

