/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.APOptions;
import com.dstc.security.kerberos.APRepImpl;
import com.dstc.security.kerberos.APReqImpl;
import com.dstc.security.kerberos.AuthorizationDataElement;
import com.dstc.security.kerberos.Checksum;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.EncryptionType;
import com.dstc.security.kerberos.FileCredentialStore;
import com.dstc.security.kerberos.FileKeyTab;
import com.dstc.security.kerberos.KDCOptions;
import com.dstc.security.kerberos.KerberosContext;
import com.dstc.security.kerberos.KerberosError;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosKey;
import com.dstc.security.kerberos.KrbASRepImpl;
import com.dstc.security.kerberos.KrbASReqImpl;
import com.dstc.security.kerberos.KrbCredImpl;
import com.dstc.security.kerberos.KrbErrorImpl;
import com.dstc.security.kerberos.KrbTGSRepImpl;
import com.dstc.security.kerberos.KrbTGSReqImpl;
import com.dstc.security.kerberos.PaData;
import com.dstc.security.kerberos.PaEncTimestamp;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.Ticket;
import com.dstc.security.kerberos.TicketImpl;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.creds.CredentialStore;
import com.dstc.security.kerberos.creds.KeyTab;
import com.dstc.security.kerberos.gssapi.GSSManager;
import com.dstc.security.kerberos.msg.APRep;
import com.dstc.security.kerberos.msg.APReq;
import com.dstc.security.kerberos.msg.KerberosMessage;
import com.dstc.security.kerberos.msg.KrbASRep;
import com.dstc.security.kerberos.msg.KrbASReq;
import com.dstc.security.kerberos.msg.KrbCred;
import com.dstc.security.kerberos.msg.KrbError;
import com.dstc.security.kerberos.msg.KrbTGSRep;
import com.dstc.security.kerberos.msg.KrbTGSReq;
import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Date;

public class Kerberos {
    public static final int DES_CBC_CRC = 1;
    public static final int DES_CBC_MD4 = 2;
    public static final int DES_CBC_MD5 = 3;
    public static final int CKSUM_CRC32 = 1;
    public static final int CKSUM_MD4 = 2;
    public static final int CKSUM_DES_MAC = 4;
    public static final int CKSUM_MD5 = 7;
    private static final int MILLIS_IN_SEC = 1000;
    private static final int SECS_IN_HOUR = 3600;
    private KerberosContext context;
    private SecureRandom random;
    private static boolean debug = false;

    private Kerberos(KerberosContext kerberosContext) {
        this.context = kerberosContext;
    }

    public static APReq createApplicationRequest(Credential credential, APOptions aPOptions, int n, Checksum checksum, EncryptionKey encryptionKey) throws KerberosException {
        if (debug) {
            System.err.println("\n** creating application request .. **");
            System.err.println("  with credentials: ");
            System.err.println(credential);
        }
        APReqImpl aPReqImpl = new APReqImpl(credential, aPOptions, new SecureRandom());
        Date date = new Date();
        aPReqImpl.setClientTime(date);
        aPReqImpl.setSequenceNumber(n);
        aPReqImpl.setSubKey(encryptionKey);
        if (checksum != null) {
            aPReqImpl.setChecksum(checksum);
        }
        aPReqImpl.encrypt();
        if (debug) {
            System.err.println("\n** application request .. **");
            System.err.println(aPReqImpl);
        }
        return aPReqImpl;
    }

    public static APRep createApplicationResponse(EncryptionKey encryptionKey, Date date, int n, int n2, EncryptionKey encryptionKey2) throws KerberosException {
        if (debug) {
            System.err.println("\n** creating application response .. **");
            System.err.println("  with key: ");
            System.err.println(encryptionKey);
        }
        APRepImpl aPRepImpl = new APRepImpl(encryptionKey, new SecureRandom());
        aPRepImpl.setClientTime(date, n);
        aPRepImpl.setSequenceNumber(n2);
        aPRepImpl.encrypt();
        if (debug) {
            System.err.println("  created application response: ");
            System.err.println(aPRepImpl);
        }
        return aPRepImpl;
    }

    public KrbASReq createKrbASReq(PrincipalName principalName, KDCOptions kDCOptions, InetAddress[] inetAddressArray, Date date, Date date2, PaData[] paDataArray) throws KerberosException {
        int n;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        KrbASReqImpl krbASReqImpl = new KrbASReqImpl();
        if (kDCOptions == null) {
            throw new KerberosException("KDCOptions are required in KrbASReq");
        }
        krbASReqImpl.setKDCOptions(kDCOptions);
        krbASReqImpl.setClientName(this.context.getPrincipalName());
        krbASReqImpl.setRealm(this.context.getRealm());
        krbASReqImpl.setServerName(principalName);
        int n2 = this.random.nextInt();
        krbASReqImpl.setNonce(n2);
        EncryptionType encryptionType = new EncryptionType(this.getContext().getSupportedEncryptionTypes());
        krbASReqImpl.setEncryptionType(encryptionType);
        if (date != null) {
            krbASReqImpl.setStartTime(date);
        }
        Date date3 = date2 != null ? date2 : new Date(System.currentTimeMillis() + (long)(3600000 * this.getContext().getDefaultTicketLifeTime()));
        krbASReqImpl.setEndTime(date3);
        Object var11_11 = null;
        if (inetAddressArray != null) {
            n = 0;
            int n3 = inetAddressArray.length;
            while (n < n3) {
                krbASReqImpl.addAddress(inetAddressArray[n]);
                ++n;
            }
        }
        if (paDataArray != null) {
            n = 0;
            while (n < paDataArray.length) {
                krbASReqImpl.addPaData(paDataArray[n]);
                ++n;
            }
        }
        krbASReqImpl.encode();
        return krbASReqImpl;
    }

    public static KrbCred createKrbCred(EncryptionKey encryptionKey, Credential[] credentialArray) throws KerberosException {
        KrbCredImpl krbCredImpl = new KrbCredImpl(encryptionKey, new SecureRandom());
        try {
            krbCredImpl.setCredentials(credentialArray);
            krbCredImpl.encrypt();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
        return krbCredImpl;
    }

    public static KrbError createKrbError(int n, String string) throws KerberosException {
        int n2 = string.lastIndexOf(64);
        String string2 = string.substring(n2 + 1);
        PrincipalName principalName = new PrincipalName(3, string.substring(0, n2));
        return Kerberos.createKrbError(n, string2, principalName);
    }

    public static KrbError createKrbError(int n, String string, PrincipalName principalName) throws KerberosException {
        if (string == null) {
            throw new KerberosException("realm cannot be null");
        }
        if (principalName == null) {
            throw new KerberosException("sName cannot be null");
        }
        Date date = new Date();
        KrbErrorImpl krbErrorImpl = new KrbErrorImpl(null, date, n, null, null, string, principalName, null, null);
        return krbErrorImpl;
    }

    public KrbTGSReq createKrbTGSReq(Credential credential, PrincipalName principalName, String string, KDCOptions kDCOptions, Date date, Date date2, InetAddress[] inetAddressArray, Ticket ticket, AuthorizationDataElement[] authorizationDataElementArray) throws KerberosException {
        int n;
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        KrbTGSReqImpl krbTGSReqImpl = new KrbTGSReqImpl(credential, 7, new APOptions(), authorizationDataElementArray);
        if (inetAddressArray != null) {
            n = 0;
            int n2 = inetAddressArray.length;
            while (n < n2) {
                krbTGSReqImpl.addAddress(inetAddressArray[n]);
                ++n;
            }
        }
        if (kDCOptions == null) {
            throw new KerberosException("KDCOptions are required in KrbTGSReq");
        }
        krbTGSReqImpl.setKDCOptions(kDCOptions);
        if (ticket != null) {
            krbTGSReqImpl.addTicket(ticket);
        }
        if (principalName == null) {
            throw new KerberosException("Missing server name in KrbTGSReq");
        }
        krbTGSReqImpl.setServerName(principalName);
        if (string != null) {
            krbTGSReqImpl.setRealm(string);
        } else {
            krbTGSReqImpl.setRealm(this.context.getRealm());
        }
        n = this.random.nextInt();
        krbTGSReqImpl.setNonce(n);
        EncryptionType encryptionType = new EncryptionType(this.getContext().getSupportedEncryptionTypes());
        krbTGSReqImpl.setEncryptionType(encryptionType);
        if (date != null) {
            krbTGSReqImpl.setStartTime(date);
        } else {
            krbTGSReqImpl.setStartTime(new Date());
        }
        Date date3 = date2 != null ? date2 : new Date(System.currentTimeMillis() + (long)(3600000 * this.getContext().getDefaultTicketLifeTime()));
        krbTGSReqImpl.setEndTime(date3);
        Object var14_15 = null;
        krbTGSReqImpl.setAuthenticator();
        krbTGSReqImpl.encode();
        return krbTGSReqImpl;
    }

    public static APReq decryptApplicationRequest(EncryptionKey encryptionKey, APReq aPReq) throws KerberosException {
        if (debug) {
            System.err.println("\n** decrypting application request .. **");
            System.err.println("  with key: ");
            System.err.println(encryptionKey);
        }
        try {
            APReqImpl aPReqImpl = new APReqImpl(aPReq.getEncoded());
            aPReqImpl.initDecrypt(encryptionKey);
            aPReqImpl.decrypt();
            if (debug) {
                System.err.println("  decrypted application request: ");
                System.err.println(aPReqImpl);
            }
            return aPReqImpl;
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public static APRep decryptApplicationResponse(EncryptionKey encryptionKey, APRep aPRep) throws KerberosException {
        if (debug) {
            System.err.println("\n** decrypting application response .. **");
            System.err.println("  with key: ");
            System.err.println(encryptionKey);
        }
        try {
            APRepImpl aPRepImpl = new APRepImpl(aPRep.getEncoded());
            aPRepImpl.initDecrypt(encryptionKey);
            aPRepImpl.decrypt();
            if (debug) {
                System.err.println("  decrypted application response: ");
                System.err.println(aPRepImpl);
            }
            return aPRepImpl;
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public static KrbCred decryptKrbCred(EncryptionKey encryptionKey, KrbCred krbCred) throws KerberosException {
        try {
            KrbCredImpl krbCredImpl = new KrbCredImpl(krbCred.getEncoded());
            krbCredImpl.initDecrypt(encryptionKey);
            krbCredImpl.decrypt();
            return krbCredImpl;
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public static Ticket decryptTicket(EncryptionKey encryptionKey, Ticket ticket) throws KerberosException {
        if (debug) {
            System.err.println("\n** decrypting ticket .. **");
            System.err.println("  with key: ");
            System.err.println(encryptionKey);
        }
        try {
            TicketImpl ticketImpl = new TicketImpl(ticket.getEncoded());
            ticketImpl.initDecrypt(encryptionKey);
            ticketImpl.decrypt();
            if (debug) {
                System.err.println("  decrypted ticket: ");
                System.err.println(ticketImpl);
            }
            return ticketImpl;
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException("Bad ticket encoding: " + asn1Exception.getMessage());
        }
    }

    public KerberosContext getContext() {
        return this.context;
    }

    public org.ietf.jgss.GSSManager getGSSManager() {
        return new GSSManager(this);
    }

    public static Kerberos getInstance() {
        KerberosContext kerberosContext = null;
        try {
            Object object;
            Object object2;
            String string = System.getProperty("jcsi.kerberos.principal");
            if (string == null && (string = System.getProperty("user.name")) == null) {
                throw new RuntimeException("Cannot create default Kerberos instance: user unknown");
            }
            String string2 = System.getProperty("jcsi.kerberos.realm");
            if (string2 == null) {
                throw new RuntimeException("Cannot create default Kerberos instance: system property jcsi.kerberos.realm not set");
            }
            String string3 = System.getProperty("jcsi.kerberos.KDChost");
            if (string3 == null) {
                throw new RuntimeException("Cannot create default Kerberos instance: system property jcsi.kerberos.KDChost not set");
            }
            kerberosContext = new KerberosContext(string2, new PrincipalName(string), InetAddress.getByName(string3));
            String string4 = System.getProperty("jcsi.kerberos.ccache");
            String string5 = System.getProperty("jcsi.kerberos.keytab");
            if (string4 == null && string5 == null) {
                throw new RuntimeException("Cannot create default Kerberos instance: one of system properties jcsi.kerberos.ccache and jcsi.kerberos.keytab must be set");
            }
            if (string4 != null) {
                object2 = new File(string4);
                object = new FileCredentialStore();
                if (((File)object2).exists()) {
                    ((FileCredentialStore)object).load((File)object2);
                } else {
                    ((File)object2).createNewFile();
                    ((FileCredentialStore)object).setDefaultUser(kerberosContext.getPrincipalName(), string2);
                }
                kerberosContext.setCredentialStore((CredentialStore)object);
            }
            if (string5 != null && ((File)(object2 = new File(string5))).exists()) {
                object = new FileKeyTab();
                ((FileKeyTab)object).load((File)object2);
                kerberosContext.setKeyTab((KeyTab)object);
            }
            if ((object2 = System.getProperty("jcsi.kerberos.debug")) != null && ((String)object2).equals("true")) {
                debug = true;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error creating default Kerberos instance: nested exception: " + exception.toString());
        }
        return new Kerberos(kerberosContext);
    }

    public static Kerberos getInstance(KerberosContext kerberosContext) {
        return new Kerberos(kerberosContext);
    }

    public KrbASRep getKrbASRepFromKDC(KrbASReq krbASReq, EncryptionKey encryptionKey) throws KerberosException, IOException {
        KerberosMessage kerberosMessage;
        block4: {
            int n = 0;
            kerberosMessage = null;
            while (true) {
                if (n >= 2) {
                    throw new KerberosError(((KrbError)kerberosMessage).getErrorCode());
                }
                kerberosMessage = this.sendRequestToKDC(krbASReq);
                if (!(kerberosMessage instanceof KrbError)) break block4;
                if (((KrbError)kerberosMessage).getErrorCode() != 25) break;
                if (!(krbASReq instanceof KrbASReqImpl)) {
                    throw new KerberosError(((KrbError)kerberosMessage).getErrorCode());
                }
                ++n;
                ((KrbASReqImpl)krbASReq).setNonce(this.random.nextInt());
                ((KrbASReqImpl)krbASReq).addPaData(new PaEncTimestamp(encryptionKey, this.random));
                ((KrbASReqImpl)krbASReq).encode();
            }
            throw new KerberosError(((KrbError)kerberosMessage).getErrorCode());
        }
        if (!(kerberosMessage instanceof KrbASRep)) {
            throw new KerberosException("Unexpected message from KDC");
        }
        return (KrbASRep)kerberosMessage;
    }

    public KrbTGSRep getKrbTGSRepFromKDC(KrbTGSReq krbTGSReq) throws KerberosException, IOException {
        KerberosMessage kerberosMessage = this.sendRequestToKDC(krbTGSReq);
        if (kerberosMessage instanceof KrbError) {
            throw new KerberosError(((KrbError)kerberosMessage).getErrorCode());
        }
        if (!(kerberosMessage instanceof KrbTGSRep)) {
            throw new KerberosException("Unexpected message from KDC");
        }
        return (KrbTGSRep)kerberosMessage;
    }

    public static KerberosMessage getMessage(byte[] byArray) throws KerberosException {
        try {
            Asn1 asn1 = Asn1.getAsn1(byArray);
            int n = asn1.getTagNumber();
            switch (n) {
                case 11: {
                    return new KrbASRepImpl(asn1);
                }
                case 13: {
                    return new KrbTGSRepImpl(asn1);
                }
                case 10: {
                    return new KrbASReqImpl(asn1);
                }
                case 12: {
                    return new KrbTGSReqImpl(asn1);
                }
                case 14: {
                    return new APReqImpl(asn1);
                }
                case 15: {
                    return new APRepImpl(asn1);
                }
                case 22: {
                    return new KrbCredImpl(asn1);
                }
                case 30: {
                    return new KrbErrorImpl(asn1);
                }
            }
            throw new KerberosException("Unknown message type");
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException("Bad encoding: " + asn1Exception.getMessage());
        }
    }

    public Credential processKrbASRep(KrbASRep krbASRep, EncryptionKey encryptionKey) throws KerberosException {
        PaData[] paDataArray;
        if (encryptionKey instanceof KerberosKey && ((KerberosKey)encryptionKey).getMixInString() != null && (paDataArray = krbASRep.getPadatas()) != null) {
            int n = 0;
            int n2 = paDataArray.length;
            while (n < n2) {
                if (paDataArray[n].type() == 3) {
                    byte[] byArray = paDataArray[n].value();
                    if (!((KerberosKey)encryptionKey).getMixInString().equals(byArray)) {
                        ((KerberosKey)encryptionKey).updateMixInString(byArray);
                    }
                }
                ++n;
            }
        }
        krbASRep.initDecrypt(encryptionKey);
        krbASRep.decrypt();
        return ((KrbASRepImpl)krbASRep).getCredential();
    }

    public Credential processKrbTGSRep(KrbTGSRep krbTGSRep, EncryptionKey encryptionKey) throws KerberosException {
        krbTGSRep.initDecrypt(encryptionKey);
        krbTGSRep.decrypt();
        return ((KrbTGSRepImpl)krbTGSRep).getCredential();
    }

    public Credential requestInitialTicket(EncryptionKey encryptionKey, PrincipalName principalName, KDCOptions kDCOptions, Date date, Date date2, InetAddress[] inetAddressArray, PaData[] paDataArray) throws KerberosException, IOException {
        if (debug) {
            System.err.println("\n** requesting initial ticket .. **");
        }
        if (inetAddressArray == null) {
            inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        }
        KrbASReq krbASReq = this.createKrbASReq(principalName, kDCOptions, inetAddressArray, date, date2, paDataArray);
        KrbASRep krbASRep = this.getKrbASRepFromKDC(krbASReq, encryptionKey);
        Credential credential = this.processKrbASRep(krbASRep, encryptionKey);
        if (krbASReq.getNonce() != krbASRep.getNonce()) {
            throw new KerberosException("Nonce in response differs from nonce in request");
        }
        if (debug) {
            System.err.println("\n** credentials obtained .. **");
            System.err.println(credential);
        }
        return credential;
    }

    public Credential requestServiceTicket(Credential credential, PrincipalName principalName, String string, KDCOptions kDCOptions) throws KerberosException, IOException {
        return this.requestServiceTicket(credential, principalName, string, kDCOptions, null, null, null, null);
    }

    public Credential requestServiceTicket(Credential credential, PrincipalName principalName, String string, KDCOptions kDCOptions, Date date, Date date2, Ticket ticket, AuthorizationDataElement[] authorizationDataElementArray) throws KerberosException, IOException {
        if (debug) {
            System.err.println("\n** requesting service ticket .. **");
            System.err.println("  with credentials: ");
            System.err.println(credential);
        }
        KrbTGSReq krbTGSReq = this.createKrbTGSReq(credential, principalName, string, kDCOptions, date, date2, null, ticket, authorizationDataElementArray);
        KrbTGSRep krbTGSRep = this.getKrbTGSRepFromKDC(krbTGSReq);
        Credential credential2 = this.processKrbTGSRep(krbTGSRep, credential.getSessionKey());
        if (krbTGSReq.getNonce() != krbTGSRep.getNonce()) {
            throw new KerberosException("Nonce in response differs from nonce in request");
        }
        if (debug) {
            System.err.println("\n** credentials obtained .. **");
            System.err.println(credential2);
        }
        return credential2;
    }

    public Credential requestTicketGrantingTicket(EncryptionKey encryptionKey, KDCOptions kDCOptions) throws KerberosException, IOException {
        return this.requestTicketGrantingTicket(encryptionKey, kDCOptions, null, null, null, null);
    }

    public Credential requestTicketGrantingTicket(EncryptionKey encryptionKey, KDCOptions kDCOptions, Date date, Date date2, InetAddress[] inetAddressArray, PaData[] paDataArray) throws KerberosException, IOException {
        if (debug) {
            System.err.println("\n** making TGT request .. **");
        }
        PrincipalName principalName = new PrincipalName(2, "krbtgt/" + this.context.getRealm());
        return this.requestInitialTicket(encryptionKey, principalName, kDCOptions, date, date2, inetAddressArray, paDataArray);
    }

    private KerberosMessage sendRequestToKDC(KerberosMessage kerberosMessage) throws KerberosException, IOException {
        byte[] byArray = this.sendUDPRequest(kerberosMessage.getEncoded(), this.context.getKDCAddress(), this.context.getKDCPort());
        return Kerberos.getMessage(byArray);
    }

    private byte[] sendUDPRequest(byte[] byArray, InetAddress inetAddress, int n) throws IOException {
        DatagramSocket datagramSocket = new DatagramSocket();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        datagramSocket.send(datagramPacket);
        byte[] byArray2 = new byte[2048];
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, 2048);
        datagramSocket.receive(datagramPacket2);
        return datagramPacket2.getData();
    }
}

