/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.kerberos.CryptoException;
import com.dstc.security.kerberos.EncryptedData;
import com.dstc.security.kerberos.EncryptedDataImpl;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.crypto.KerberosMac;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class KerberosCipher {
    public static final String DES = "DES";
    public static final String DESede = "DESede";
    public static final String DES_CBC_ZEROES = "DES/CBC/Zeroes";
    public static final String DESede_CBC_ZEROES = "DESede/CBC/Zeroes";
    public static int CONFOUNDER_LEN = 8;
    public static int MD5_CKSUM_LEN = 16;
    public static int CRC_CKSUM_LEN = 4;
    public static int HMAC_SHA1_CKSUM_LEN = 20;
    private int beginData;
    private int cksumLength;
    private Cipher cipher;
    private String alg;
    private KerberosMac mac;
    private int encType;
    private byte[] keyBytes;
    private SecureRandom rand;
    private int confounderLength = CONFOUNDER_LEN;

    private KerberosCipher(int n, String string) throws KerberosException {
        this.encType = n;
        String string2 = null;
        switch (this.encType) {
            case 1: {
                this.cksumLength = CRC_CKSUM_LEN;
                string2 = DES_CBC_ZEROES;
                this.alg = DES;
                this.mac = KerberosMac.getInstance(1);
                break;
            }
            case 2: {
                this.cksumLength = MD5_CKSUM_LEN;
                string2 = DES_CBC_ZEROES;
                this.alg = DES;
                this.mac = KerberosMac.getInstance(2);
                break;
            }
            case 3: {
                this.cksumLength = MD5_CKSUM_LEN;
                string2 = DES_CBC_ZEROES;
                this.alg = DES;
                this.mac = KerberosMac.getInstance(7);
                break;
            }
            default: {
                throw new KerberosException("Unsupported enc type: " + n);
            }
        }
        this.beginData = this.confounderLength + this.cksumLength;
        try {
            this.cipher = string == null ? Cipher.getInstance(string2) : Cipher.getInstance(string2, string);
        }
        catch (Exception exception) {
            throw new KerberosException("Provider error: " + exception.getMessage());
        }
    }

    static boolean checkEncType(int n, int n2) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return n2 == 1 || n2 == 2 || n2 == 3;
            }
        }
        return n2 == n;
    }

    public byte[] decrypt(EncryptedData encryptedData) throws CryptoException {
        if (encryptedData.getEncryptionType() == 0) {
            return encryptedData.getCipherText();
        }
        if (!KerberosCipher.checkEncType(this.encType, encryptedData.getEncryptionType())) {
            throw new CryptoException("Encryption type mismatch");
        }
        try {
            byte[] byArray = this.cipher.doFinal(encryptedData.getCipherText());
            byte[] byArray2 = new byte[this.cksumLength];
            System.arraycopy(byArray, this.confounderLength, byArray2, 0, this.cksumLength);
            int n = this.confounderLength;
            while (n < this.beginData) {
                byArray[n] = 0;
                ++n;
            }
            byte[] byArray3 = new byte[byArray.length - this.beginData];
            System.arraycopy(byArray, this.beginData, byArray3, 0, byArray3.length);
            this.mac.update(byArray);
            byte[] byArray4 = this.mac.doFinal();
            if (!Arrays.equals(byArray2, byArray4)) {
                throw new CryptoException("Integrity check failure");
            }
            return byArray3;
        }
        catch (Exception exception) {
            throw new CryptoException(exception.toString());
        }
    }

    public byte[] encrypt(byte[] byArray) throws CryptoException {
        byte[] byArray2 = new byte[this.confounderLength];
        this.rand.nextBytes(byArray2);
        int n = this.beginData + byArray.length;
        int n2 = 8 - n % 8;
        byte[] byArray3 = new byte[n + (n2 == 8 ? 0 : n2)];
        System.arraycopy(byArray2, 0, byArray3, 0, this.confounderLength);
        System.arraycopy(byArray, 0, byArray3, this.beginData, byArray.length);
        this.mac.update(byArray3);
        byte[] byArray4 = this.mac.doFinal();
        System.arraycopy(byArray4, 0, byArray3, this.confounderLength, this.cksumLength);
        try {
            byte[] byArray5 = this.cipher.doFinal(byArray3);
            return new EncryptedDataImpl(this.encType, byArray5).getEncoded();
        }
        catch (Exception exception) {
            throw new CryptoException(exception.toString());
        }
    }

    public static KerberosCipher getInstance(int n, String string) throws KerberosException {
        return new KerberosCipher(n, string);
    }

    private void init(int n, SecretKey secretKey) {
        byte[] byArray = new byte[8];
        IvParameterSpec ivParameterSpec = this.encType == 1 ? new IvParameterSpec(secretKey.getEncoded()) : new IvParameterSpec(byArray);
        try {
            this.cipher.init(n, (Key)secretKey, ivParameterSpec);
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.getMessage());
        }
    }

    public void initDecrypt(EncryptionKey encryptionKey, SecureRandom secureRandom) {
        this.init(2, new SecretKeySpec(encryptionKey.keyValue(), this.alg));
    }

    public void initEncrypt(EncryptionKey encryptionKey, SecureRandom secureRandom) {
        this.rand = secureRandom;
        this.init(1, new SecretKeySpec(encryptionKey.keyValue(), this.alg));
    }
}

