/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.creds.CredentialStore;
import com.dstc.security.kerberos.creds.KeyTab;
import java.net.InetAddress;

public final class KerberosContext {
    private String realm;
    private int[] eTypes = new int[]{3, 1};
    private PrincipalName name;
    private InetAddress kdcAddr;
    private int kdcPort = 88;
    private CredentialStore store;
    private KeyTab keytab;
    private int defLifeTime = 10;

    public KerberosContext(String string, PrincipalName principalName, InetAddress inetAddress) {
        if (string == null) {
            throw new IllegalArgumentException("Realm is null");
        }
        this.realm = string;
        if (principalName == null) {
            throw new IllegalArgumentException("Name is null");
        }
        this.name = principalName;
        if (inetAddress == null) {
            throw new IllegalArgumentException("KDC address is null");
        }
        this.kdcAddr = inetAddress;
    }

    public CredentialStore getCredentialStore() {
        return this.store;
    }

    public int getDefaultTicketLifeTime() {
        return this.defLifeTime;
    }

    public InetAddress getKDCAddress() {
        return this.kdcAddr;
    }

    public int getKDCPort() {
        return this.kdcPort;
    }

    public KeyTab getKeyTab() {
        return this.keytab;
    }

    public PrincipalName getPrincipalName() {
        return this.name;
    }

    public String getRealm() {
        return this.realm;
    }

    public int[] getSupportedEncryptionTypes() {
        return this.eTypes;
    }

    public void setCredentialStore(CredentialStore credentialStore) {
        this.store = credentialStore;
    }

    public void setDefaultTicketLifeTime(int n) {
        this.defLifeTime = n;
    }

    public void setKDCAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("KDC host is null");
        }
        this.kdcAddr = inetAddress;
    }

    public void setKDCPort(int n) {
        this.kdcPort = n;
    }

    public void setKeyTab(KeyTab keyTab) {
        this.keytab = keyTab;
    }

    public void setPrincipalName(PrincipalName principalName) {
        if (this.realm == null) {
            throw new IllegalArgumentException("Name is null");
        }
        this.name = principalName;
    }

    public void setRealm(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Realm is null");
        }
        this.realm = string;
    }

    public void setSupportedEncryptionTypes(int[] nArray) {
        this.eTypes = nArray;
    }
}

