/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.kerberos.KerberosException;

public class KerberosError
extends KerberosException {
    public static final int NO_ERROR = 0;
    public static final int KDC_ERR_NAME_EXP = 1;
    public static final int KDC_ERR_SERVICE_EXP = 2;
    public static final int KDC_ERR_BAD_PVNO = 3;
    public static final int KDC_ERR_C_OLD_MAST_KVNO = 4;
    public static final int KDC_ERR_S_OLD_MAST_KVNO = 5;
    public static final int KDC_ERR_C_PRINCIPAL_UNKNOWN = 6;
    public static final int KDC_ERR_S_PRINCIPAL_UNKNOWN = 7;
    public static final int KDC_ERR_PRINCIPAL_NOT_UNIQUE = 8;
    public static final int KDC_ERR_NULL_KEY = 9;
    public static final int KDC_ERR_CANNOT_POSTDATE = 10;
    public static final int KDC_ERR_NEVER_VALID = 11;
    public static final int KDC_ERR_POLICY = 12;
    public static final int KDC_ERR_BADOPTION = 13;
    public static final int KDC_ERR_ETYPE_NOSUPP = 14;
    public static final int KDC_ERR_SUMTYPE_NOSUPP = 15;
    public static final int KDC_ERR_PADATA_TYPE_NOSUPP = 16;
    public static final int KDC_ERR_TRTYPE_NOSUPP = 17;
    public static final int KDC_ERR_CLIENT_REVOKED = 18;
    public static final int KDC_ERR_SERVICE_REVOKED = 19;
    public static final int KDC_ERR_TGT_REVOKED = 20;
    public static final int KDC_ERR_CLIENT_NOTYET = 21;
    public static final int KDC_ERR_SERVICE_NOTYET = 22;
    public static final int KDC_ERR_KEY_EXPIRED = 23;
    public static final int KDC_ERR_PREAUTH_FAILED = 24;
    public static final int KDC_ERR_PREAUTH_REQUIRED = 25;
    public static final int KDC_ERR_SERVER_NOMATCH = 26;
    public static final int KDC_ERR_MUST_USE_USER2USER = 27;
    public static final int KDC_ERR_PATH_NOT_ACCEPTED = 28;
    public static final int KRB_AP_ERR_BAD_INTEGRITY = 31;
    public static final int KRB_AP_ERR_TKT_EXPIRED = 32;
    public static final int KRB_AP_ERR_TKT_NYV = 33;
    public static final int KRB_AP_ERR_REPEAT = 34;
    public static final int KRB_AP_ERR_NOT_US = 35;
    public static final int KRB_AP_ERR_BADMATCH = 36;
    public static final int KRB_AP_ERR_SKEW = 37;
    public static final int KRB_AP_ERR_BADADDR = 38;
    public static final int KRB_AP_ERR_BADVERSION = 39;
    public static final int KRB_AP_ERR_MSG_TYPE = 40;
    public static final int KRB_AP_ERR_MODIFIED = 41;
    public static final int KRB_AP_ERR_BADORDER = 42;
    public static final int KRB_AP_ERR_BADKEYVER = 44;
    public static final int KRB_AP_ERR_NOKEY = 45;
    public static final int KRB_AP_ERR_MUT_FAILED = 46;
    public static final int KRB_AP_ERR_BADDIRECTION = 47;
    public static final int KRB_AP_ERR_METHOD = 48;
    public static final int KRB_AP_ERR_BADSEQ = 49;
    public static final int KRB_AP_ERR_INAPP_CKSUM = 50;
    public static final int KRB_AP_PATH_NOT_ACCEPTED = 51;
    public static final int KRB_ERR_GENERIC = 60;
    public static final int KRB_ERR_FIELD_TOOLONG = 61;
    public static final int KRB_IMPL_ERR_CONFIG = 128;
    private static final int MIN_STD_ERR = 0;
    private static final int MAX_STD_ERR = 61;
    private static final int MIN_IMPL_ERR = 128;
    private static final int MAX_IMPL_ERR = 128;
    private static final String[] stdErrMessages = new String[]{"No error", "Client's entry in the database has expired", "Server's entry in the database has expired", "Requested protocol version not supported", "Client's key is encrypted in an old master key", "Server's key is encrypted in an old master key", "Client not found in Kerberos database", "Server not found in Kerberos database", "Principal has multiple entries in Kerberos database", "Client or server has a null key", "Ticket is ineligible for postdating", "Requested effective lifetime is negative or too short", "KDC policy rejects request", "KDC can't fulfill requested option", "KDC has no support for encryption type", "KDC has no support for checksum type", "KDC has no support for padata type", "KDC has no support for transited type", "Clients credentials have been revoked", "Credentials for server have been revoked", "TGT has been revoked", "Client not yet valid - try again later", "Server not yet valid - try again later", "Password has expired - change password to reset", "Pre-authentication information was invalid", "Additional pre-authentication required", "Requested server and ticket don't match", "Server principal valid for user2user only", "KDC policy rejects transited path", "", "", "Integrity checked on decrypted field failed", "Ticket expired", "Ticket not yet valid", "Request is a replay", "The ticket isn't for us", "Ticket and authenticator don't match", "Clock skew too great", "Incorrect net address", "Protocol version mismatch", "Invalid message type", "Message stream modified", "Message out of order", "", "Specified version of key is not available", "Service key not available", "Mutual authentication failed", "Incorrect message direction", "Alternative authentication method required", "Incorrect sequence number in message", "Inappropriate type of checksum in message", "Policy rejects transited path", "", "", "", "", "", "", "", "", "Generic error (description in e-text)", "Field is too long for this implementation"};
    private static final String[] implErrMessages = new String[]{"Error in configuration file"};
    private int code = 0;

    public KerberosError() {
    }

    public KerberosError(int n) {
        super(KerberosError.code2Message(n));
        this.code = n;
    }

    public KerberosError(String string) {
        super(string);
    }

    private static String code2Message(int n) {
        if (n < 0 || n > 61 && n < 128 || n > 128 || n == 29 || n == 30 || n == 43 || n > 51 && n < 60) {
            n = 60;
        }
        if (n < 128) {
            return stdErrMessages[n];
        }
        return implErrMessages[n - 128];
    }

    public int getErrorCode() {
        return this.code;
    }
}

