/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.crypto.DESKerberosKey;

public abstract class KerberosKey
implements EncryptionKey {
    private int type;
    private byte[] keyBytes = null;
    private byte[] passString;
    private byte[] mixInString;

    protected KerberosKey(int n, byte[] byArray) {
        this.type = n;
        this.keyBytes = byArray;
    }

    protected KerberosKey(int n, byte[] byArray, byte[] byArray2) throws KerberosException {
        this.type = n;
        this.passString = byArray;
        this.mixInString = byArray2;
        this.keyBytes = this.stringToKey(byArray, byArray2);
    }

    public static KerberosKey getInstance(int n, byte[] byArray) throws KerberosException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return new DESKerberosKey(n, byArray);
            }
        }
        throw new KerberosException("keytype unsupported");
    }

    public static KerberosKey getInstance(int n, byte[] byArray, byte[] byArray2) throws KerberosException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return new DESKerberosKey(n, byArray, byArray2);
            }
        }
        throw new KerberosException("keytype unsupported");
    }

    public byte[] getMixInString() {
        return this.mixInString;
    }

    public int keyType() {
        return this.type;
    }

    public byte[] keyValue() {
        return this.keyBytes;
    }

    protected abstract byte[] stringToKey(byte[] var1, byte[] var2) throws KerberosException;

    public void updateMixInString(byte[] byArray) throws KerberosException {
        this.mixInString = byArray;
        this.keyBytes = this.stringToKey(this.passString, byArray);
    }
}

