/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.CredentialImpl;
import com.dstc.security.kerberos.EncKrbCredPart;
import com.dstc.security.kerberos.EncryptedDataImpl;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.KerberosCipher;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KrbCredInfoImpl;
import com.dstc.security.kerberos.NotYetDecryptedException;
import com.dstc.security.kerberos.Ticket;
import com.dstc.security.kerberos.TicketImpl;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.msg.KrbCred;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

final class KrbCredImpl
implements KrbCred {
    private static final int pvno = 5;
    private Asn1 asn1 = null;
    private int msgType = 22;
    private Vector tickets;
    private EncryptedDataImpl encPart;
    private KerberosCipher cipher;
    private int nonce;
    private Date timestamp;
    private InetAddress sAddr;
    private InetAddress rAddr;
    private EncKrbCredPart encKrbCredPart;
    private Vector creds;

    KrbCredImpl(Asn1 asn1) throws Asn1Exception, KerberosException {
        this.asn1 = asn1;
        if (this.asn1.getTagNumber() != 22) {
            throw new KerberosException("Wrong tag for a KrbCred");
        }
        Iterator iterator = ((Sequence)asn1.components().next()).components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (((Integer)asn12.components().next()).getInt() != 5) {
            throw new KerberosException("Bad version number");
        }
        asn12 = (Asn1)iterator.next();
        if (((Integer)asn12.components().next()).getInt() != this.msgType) {
            throw new KerberosException("Bad msgType for a KrbCred");
        }
        asn12 = (Asn1)iterator.next();
        Iterator iterator2 = ((Sequence)asn12.components().next()).components();
        this.tickets = new Vector();
        while (iterator2.hasNext()) {
            this.tickets.add(new TicketImpl((Asn1)iterator2.next()));
        }
        asn12 = (Asn1)iterator.next();
        this.encPart = new EncryptedDataImpl((Asn1)asn12.components().next());
    }

    KrbCredImpl(EncryptionKey encryptionKey, SecureRandom secureRandom) throws KerberosException {
        this.cipher = KerberosCipher.getInstance(encryptionKey.keyType(), null);
        this.cipher.initEncrypt(encryptionKey, secureRandom);
    }

    KrbCredImpl(byte[] byArray) throws Asn1Exception, KerberosException {
        this(Asn1.getAsn1(byArray));
    }

    public void decrypt() throws KerberosException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        try {
            this.encKrbCredPart = new EncKrbCredPart(Asn1.getAsn1(this.cipher.decrypt(this.encPart)));
            this.nonce = this.encKrbCredPart.getNonce();
            this.sAddr = this.encKrbCredPart.getSenderAddress();
            this.rAddr = this.encKrbCredPart.getReceiverAddress();
            this.timestamp = this.encKrbCredPart.getTimestamp();
            Vector vector = this.encKrbCredPart.getTicketInfo();
            this.creds = new Vector();
            int n = 0;
            while (n < vector.size()) {
                KrbCredInfoImpl krbCredInfoImpl = (KrbCredInfoImpl)vector.elementAt(n);
                this.creds.add(new CredentialImpl((TicketImpl)this.tickets.elementAt(n), krbCredInfoImpl.getSessionKey(), krbCredInfoImpl.getClientRealm(), krbCredInfoImpl.getClientName(), krbCredInfoImpl.getServerRealm(), krbCredInfoImpl.getServerName(), krbCredInfoImpl.getClientAddresses(), krbCredInfoImpl.getTicketFlags(), krbCredInfoImpl.getAuthTime(), krbCredInfoImpl.getStartTime(), krbCredInfoImpl.getEndTime(), krbCredInfoImpl.getRenewTill()));
                ++n;
            }
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    private void encode() throws KerberosException, Asn1Exception {
        this.asn1 = new Explicit(64, this.msgType);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(5));
        sequence.add(explicit);
        explicit = new Explicit(128, 1);
        explicit.add(new Integer(this.msgType));
        sequence.add(explicit);
        Sequence sequence2 = new Sequence();
        Iterator iterator = ((AbstractList)this.tickets).iterator();
        while (iterator.hasNext()) {
            sequence2.add(new TicketImpl(((Ticket)iterator.next()).getEncoded()).getAsn1());
        }
        explicit = new Explicit(128, 2);
        explicit.add(sequence2);
        sequence.add(explicit);
        this.encPart = this.encPart;
        explicit = new Explicit(128, 3);
        explicit.add(this.encPart.getAsn1());
        sequence.add(explicit);
        this.asn1.add(sequence);
    }

    void encrypt() throws KerberosException, Asn1Exception {
        if (this.creds == null) {
            throw new KerberosException("Credentials not set in KrbCred");
        }
        Iterator iterator = ((AbstractList)this.creds).iterator();
        Vector<KrbCredInfoImpl> vector = new Vector<KrbCredInfoImpl>();
        while (iterator.hasNext()) {
            vector.add(new KrbCredInfoImpl((Credential)iterator.next()));
        }
        this.encKrbCredPart = new EncKrbCredPart(vector, this.nonce, this.sAddr, this.rAddr);
        this.encPart = new EncryptedDataImpl(this.cipher.encrypt(this.encKrbCredPart.getEncoded()));
        this.encode();
    }

    public int encryptionType() {
        return this.encPart.getEncryptionType();
    }

    public byte[] getEncoded() throws KerberosException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public int getNonce() throws NotYetDecryptedException {
        if (this.encKrbCredPart == null) {
            throw new NotYetDecryptedException("KrbCred not yet decrypted");
        }
        return this.nonce;
    }

    public InetAddress getReceiverAddress() throws NotYetDecryptedException {
        if (this.encKrbCredPart == null) {
            throw new NotYetDecryptedException("KrbCred not yet decrypted");
        }
        return this.rAddr;
    }

    public InetAddress getSenderAddress() throws NotYetDecryptedException {
        if (this.encKrbCredPart == null) {
            throw new NotYetDecryptedException("KrbCred not yet decrypted");
        }
        return this.sAddr;
    }

    public Credential[] getTicketInfo() throws NotYetDecryptedException {
        if (this.encKrbCredPart == null) {
            throw new NotYetDecryptedException("KrbCred not yet decrypted");
        }
        if (this.creds == null) {
            return null;
        }
        Credential[] credentialArray = new Credential[this.creds.size()];
        this.creds.toArray(credentialArray);
        return credentialArray;
    }

    public Ticket[] getTickets() {
        Ticket[] ticketArray = new Ticket[this.tickets.size()];
        this.tickets.toArray(ticketArray);
        return ticketArray;
    }

    public Date getTimeStamp() throws NotYetDecryptedException {
        if (this.encKrbCredPart == null) {
            throw new NotYetDecryptedException("KrbCred not yet decrypted");
        }
        return this.timestamp;
    }

    public void initDecrypt(EncryptionKey encryptionKey) throws KerberosException {
        if (encryptionKey == null) {
            throw new KerberosException("key is null");
        }
        int n = this.encPart.getEncryptionType();
        if (!KerberosCipher.checkEncType(n, encryptionKey.keyType())) {
            throw new KerberosException("key type mismatch");
        }
        this.cipher = KerberosCipher.getInstance(n, null);
        this.cipher.initDecrypt(encryptionKey, null);
    }

    void setCredentials(Credential[] credentialArray) throws Asn1Exception, KerberosException {
        this.creds = new Vector();
        this.tickets = new Vector();
        int n = 0;
        while (n < credentialArray.length) {
            this.creds.add(credentialArray[n]);
            this.tickets.add(credentialArray[n].getTicket());
            ++n;
        }
    }

    void setNonce(int n) {
        this.nonce = n;
    }

    void setRecipientAddress(InetAddress inetAddress) {
        this.rAddr = inetAddress;
    }

    void setSenderAddress(InetAddress inetAddress) {
        this.sAddr = inetAddress;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n++++ KRB-CRED Message ++++");
        stringBuffer.append("\nencryption type: " + this.encryptionType());
        if (this.encKrbCredPart != null) {
            stringBuffer.append(" (DECRYPTED OK)");
        }
        try {
            stringBuffer.append("\nsender address: " + this.getSenderAddress());
            stringBuffer.append("\nreceiver address: " + this.getReceiverAddress());
            stringBuffer.append("\nnonce: " + this.getNonce());
            stringBuffer.append("\ntimestamp: " + this.getTimeStamp());
        }
        catch (NotYetDecryptedException notYetDecryptedException) {}
        stringBuffer.append("\n++++++++++++++++++++++++++++");
        return stringBuffer.toString();
    }
}

