/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.msg.KrbError;
import java.util.Date;
import java.util.Iterator;

final class KrbErrorImpl
implements KrbError {
    private Asn1 asn1 = null;
    private int pvno;
    private int msgType = 30;
    private Date ctime = null;
    private int cusec = -1;
    private Date stime;
    private int susec;
    private int errorCode;
    private String crealm = null;
    private PrincipalName cname = null;
    private String realm;
    private PrincipalName sname;
    private String eText = null;
    private byte[] eData = null;

    KrbErrorImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = ((Sequence)asn1.components().next()).components();
        Asn1 asn12 = (Asn1)iterator.next();
        this.pvno = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        this.msgType = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 2) {
            this.ctime = ((GeneralizedTime)asn12.components().next()).getDate();
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 3) {
            this.cusec = ((Integer)asn12.components().next()).getInt();
            asn12 = (Asn1)iterator.next();
        }
        this.stime = ((GeneralizedTime)asn12.components().next()).getDate();
        asn12 = (Asn1)iterator.next();
        this.susec = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        this.errorCode = ((Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 7) {
            this.crealm = ((GeneralString)asn12.components().next()).getString();
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 8) {
            this.cname = new PrincipalName((Asn1)asn12.components().next());
            asn12 = (Asn1)iterator.next();
        }
        this.realm = ((GeneralString)asn12.components().next()).getString();
        asn12 = (Asn1)iterator.next();
        this.sname = new PrincipalName((Asn1)asn12.components().next());
        if (!iterator.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 11) {
            this.eText = ((GeneralString)asn12.components().next()).getString();
        }
        if (!iterator.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator.next();
        this.eData = ((OctetString)asn12.components().next()).getBytes();
    }

    KrbErrorImpl(Date date, Date date2, int n, String string, PrincipalName principalName, String string2, PrincipalName principalName2, String string3, byte[] byArray) throws KerberosException {
        long l;
        long l2;
        this.asn1 = new Explicit(64, this.msgType);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(this.pvno));
        sequence.add(explicit);
        explicit = new Explicit(128, 1);
        explicit.add(new Integer(this.msgType));
        sequence.add(explicit);
        if (date != null) {
            l2 = date.getTime();
            l = l2 / 1000L * 1000L;
            this.ctime = new Date(l);
            explicit = new Explicit(128, 2);
            explicit.add(new GeneralizedTime(date));
            sequence.add(explicit);
            this.cusec = (int)(l2 - l) * 1000;
            explicit = new Explicit(128, 3);
            explicit.add(new Integer(this.cusec));
            sequence.add(explicit);
        }
        l2 = date2.getTime();
        l = l2 / 1000L * 1000L;
        this.stime = new Date(l);
        explicit = new Explicit(128, 4);
        explicit.add(new GeneralizedTime(date2));
        sequence.add(explicit);
        this.susec = (int)(l2 - l) * 1000;
        explicit = new Explicit(128, 5);
        explicit.add(new Integer(this.susec));
        sequence.add(explicit);
        this.errorCode = n;
        explicit = new Explicit(128, 6);
        explicit.add(new Integer(n));
        sequence.add(explicit);
        if (string != null) {
            this.crealm = string;
            explicit = new Explicit(128, 7);
            explicit.add(new GeneralString(string));
            sequence.add(explicit);
        }
        if (principalName != null) {
            this.cname = principalName;
            explicit = new Explicit(128, 8);
            explicit.add(principalName.getAsn1());
            sequence.add(explicit);
        }
        if (string2 == null) {
            throw new KerberosException("Realm cannot be null");
        }
        this.realm = string2;
        explicit = new Explicit(128, 9);
        explicit.add(new GeneralString(string2));
        sequence.add(explicit);
        if (principalName2 == null) {
            throw new KerberosException("Server name cannot be null");
        }
        this.sname = principalName2;
        explicit = new Explicit(128, 10);
        explicit.add(this.sname.getAsn1());
        sequence.add(explicit);
        if (string3 != null) {
            this.eText = string3;
            explicit = new Explicit(128, 11);
            explicit.add(new GeneralString(string3));
            sequence.add(explicit);
        }
        if (byArray != null) {
            this.eData = byArray;
            explicit = new Explicit(128, 12);
            explicit.add(new OctetString(byArray));
            sequence.add(explicit);
        }
        this.asn1.add(sequence);
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public PrincipalName getClientName() {
        return this.cname;
    }

    public String getClientRealm() {
        return this.crealm;
    }

    public Date getClientTime() {
        return new Date(this.ctime.getTime() + (long)(this.cusec / 1000));
    }

    public byte[] getEncoded() throws KerberosException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public byte[] getErrorData() {
        return this.eData;
    }

    public String getMessage() {
        return this.eText;
    }

    public String getRealm() {
        return this.realm;
    }

    public PrincipalName getServerName() {
        return this.sname;
    }

    public Date getServerTime() {
        return new Date(this.stime.getTime() + (long)(this.susec / 1000));
    }
}

