/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.kerberos.TicketFlags;

final class TicketFlagsImpl
implements TicketFlags {
    private Asn1 asn1 = null;
    private byte[] contents;

    TicketFlagsImpl(int n) {
        this.contents = new byte[4];
        this.contents[0] = (byte)(n >> 24 & 0xFF);
        this.contents[1] = (byte)(n >> 16 & 0xFF);
        this.contents[2] = (byte)(n >> 8 & 0xFF);
        this.contents[3] = (byte)(n & 0xFF);
        this.asn1 = new BitString(this.contents);
    }

    TicketFlagsImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        this.contents = ((BitString)asn1).getBytes();
    }

    TicketFlagsImpl(TicketFlags ticketFlags) {
        this.contents = new byte[4];
        if (ticketFlags.forwardable()) {
            this.setForwardable();
        }
        if (ticketFlags.forwarded()) {
            this.setForwarded();
        }
        if (ticketFlags.proxiable()) {
            this.setProxiable();
        }
        if (ticketFlags.proxy()) {
            this.setProxy();
        }
        if (ticketFlags.mayPostdate()) {
            this.setMayPostdate();
        }
        if (ticketFlags.postdated()) {
            this.setPostdated();
        }
        if (ticketFlags.invalid()) {
            this.setInvalid();
        }
        if (ticketFlags.renewable()) {
            this.setRenewable();
        }
        if (ticketFlags.initial()) {
            this.setInitial();
        }
        this.asn1 = new BitString(this.contents);
    }

    public boolean forwardable() {
        return (this.contents[0] & 0x40) != 0;
    }

    public boolean forwarded() {
        return (this.contents[0] & 0x20) != 0;
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public int getIntMask() {
        int n = (this.contents[0] & 0xFF) << 24 | (this.contents[1] & 0xFF) << 16 | (this.contents[2] & 0xFF) << 8 | this.contents[3] & 0xFF;
        return n;
    }

    public boolean initial() {
        return (this.contents[1] & 0x40) != 0;
    }

    public boolean invalid() {
        return (this.contents[0] & 1) != 0;
    }

    public boolean mayPostdate() {
        return (this.contents[0] & 4) != 0;
    }

    public boolean postdated() {
        return (this.contents[0] & 2) != 0;
    }

    public boolean proxiable() {
        return (this.contents[0] & 0x10) != 0;
    }

    public boolean proxy() {
        return (this.contents[0] & 8) != 0;
    }

    public boolean renewable() {
        return (this.contents[1] & 0x80) != 0;
    }

    void setForwardable() {
        this.contents[0] = (byte)(this.contents[0] | 0x40);
    }

    void setForwarded() {
        this.contents[0] = (byte)(this.contents[0] | 0x20);
    }

    void setInitial() {
        this.contents[0] = (byte)(this.contents[0] | 0x40);
    }

    void setInvalid() {
        this.contents[0] = (byte)(this.contents[0] | 1);
    }

    void setMayPostdate() {
        this.contents[0] = (byte)(this.contents[0] | 4);
    }

    void setPostdated() {
        this.contents[0] = (byte)(this.contents[0] | 2);
    }

    void setProxiable() {
        this.contents[0] = (byte)(this.contents[0] | 0x10);
    }

    void setProxy() {
        this.contents[0] = (byte)(this.contents[0] | 8);
    }

    void setRenewable() {
        this.contents[0] = (byte)(this.contents[0] | 0x80);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.forwardable()) {
            stringBuffer.append("forwardable ");
        }
        if (this.forwarded()) {
            stringBuffer.append("forwarded ");
        }
        if (this.proxiable()) {
            stringBuffer.append("proxiable ");
        }
        if (this.proxy()) {
            stringBuffer.append("proxy ");
        }
        if (this.mayPostdate()) {
            stringBuffer.append("may-postdate ");
        }
        if (this.postdated()) {
            stringBuffer.append("postdated ");
        }
        if (this.invalid()) {
            stringBuffer.append("invalid ");
        }
        if (this.renewable()) {
            stringBuffer.append("renewable ");
        }
        if (this.initial()) {
            stringBuffer.append("initial ");
        }
        return stringBuffer.toString();
    }
}

