/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.AuthorizationDataElement;
import com.dstc.security.kerberos.DecryptionException;
import com.dstc.security.kerberos.EncTicketPart;
import com.dstc.security.kerberos.EncryptedDataImpl;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.EncryptionKeyImpl;
import com.dstc.security.kerberos.KerberosCipher;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.NotYetDecryptedException;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.Ticket;
import com.dstc.security.kerberos.TicketFlags;
import com.dstc.security.kerberos.TicketFlagsImpl;
import com.dstc.security.kerberos.TransitedEncoding;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

final class TicketImpl
implements Ticket {
    public static final int TAG_KRB_TICKET = 1;
    public static final int tktVno = 5;
    private Asn1 asn1 = null;
    private KerberosCipher cipher;
    private String realm;
    private PrincipalName sname;
    private EncryptedDataImpl encPart;
    private EncTicketPart encTicketPart;
    private TicketFlagsImpl flags;
    private EncryptionKeyImpl sessionKey;
    private String crealm;
    private PrincipalName cname;
    private TransitedEncoding transited;
    private Date authtime;
    private Date starttime;
    private Date endtime;
    private Date renewTill;
    private Vector caddr;
    private Vector authData;
    private boolean decryptedOK = false;

    TicketImpl(Asn1 asn1) throws Asn1Exception, KerberosException {
        this.asn1 = asn1;
        Iterator iterator = ((Sequence)asn1.components().next()).components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (((Integer)asn12.components().next()).getInt() != 5) {
            throw new KerberosException("Not version 5");
        }
        asn12 = (Asn1)iterator.next();
        this.realm = ((GeneralString)asn12.components().next()).getString();
        asn12 = (Asn1)iterator.next();
        this.sname = new PrincipalName((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator.next();
        this.encPart = new EncryptedDataImpl((Asn1)asn12.components().next());
    }

    TicketImpl(EncryptionKeyImpl encryptionKeyImpl, SecureRandom secureRandom) throws KerberosException {
        this.cipher = KerberosCipher.getInstance(encryptionKeyImpl.keyType(), null);
        this.cipher.initEncrypt(encryptionKeyImpl, secureRandom);
    }

    TicketImpl(byte[] byArray) throws Asn1Exception, KerberosException {
        this(Asn1.getAsn1(byArray));
    }

    public void decrypt() throws KerberosException {
        if (this.cipher == null) {
            throw new DecryptionException("Cipher not yet set");
        }
        try {
            this.encTicketPart = new EncTicketPart(Asn1.getAsn1(this.cipher.decrypt(this.encPart)));
            this.decryptedOK = true;
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
        this.flags = this.encTicketPart.getTicketFlags();
        this.sessionKey = this.encTicketPart.getKey();
        this.crealm = this.encTicketPart.getRealm();
        this.cname = this.encTicketPart.getClientName();
        this.transited = this.encTicketPart.getTransited();
        this.authtime = this.encTicketPart.getAuthTime();
        this.starttime = this.encTicketPart.getStartTime();
        this.endtime = this.encTicketPart.getEndTime();
        this.renewTill = this.encTicketPart.getRenewTill();
        this.caddr = this.encTicketPart.getClientAddresses();
        this.authData = this.encTicketPart.getAuthData();
    }

    private void encode() {
        this.asn1 = new Explicit(64, 1);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(5));
        sequence.add(explicit);
        explicit = new Explicit(128, 1);
        explicit.add(new GeneralString(this.realm));
        sequence.add(explicit);
        explicit = new Explicit(128, 2);
        explicit.add(this.sname.getAsn1());
        sequence.add(explicit);
        explicit = new Explicit(128, 3);
        explicit.add(this.encPart.getAsn1());
        sequence.add(explicit);
        this.asn1.add(sequence);
    }

    void encrypt() throws KerberosException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.encTicketPart = new EncTicketPart(this.flags, this.sessionKey, this.crealm, this.cname, this.transited, this.authtime, this.starttime, this.endtime, this.renewTill, this.caddr, this.authData);
        try {
            this.encPart = new EncryptedDataImpl(this.cipher.encrypt(this.encTicketPart.getEncoded()));
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
        this.encode();
    }

    public int encryptionType() {
        return this.encPart.getEncryptionType();
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public AuthorizationDataElement[] getAuthData() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        if (this.authData == null) {
            return null;
        }
        AuthorizationDataElement[] authorizationDataElementArray = new AuthorizationDataElement[this.authData.size()];
        this.authData.toArray(authorizationDataElementArray);
        return authorizationDataElementArray;
    }

    public Date getAuthTime() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        return this.authtime;
    }

    public InetAddress[] getClientAddresses() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        if (this.caddr == null) {
            return null;
        }
        InetAddress[] inetAddressArray = new InetAddress[this.caddr.size()];
        this.caddr.toArray(inetAddressArray);
        return inetAddressArray;
    }

    public PrincipalName getClientName() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        return this.cname;
    }

    public String getClientRealm() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        return this.crealm;
    }

    public byte[] getEncoded() throws KerberosException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public Date getEndTime() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        return this.endtime;
    }

    public EncryptionKey getKey() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        return this.sessionKey;
    }

    public String getRealm() {
        return this.realm;
    }

    public Date getRenewTill() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        return this.renewTill;
    }

    public PrincipalName getServerName() {
        return this.sname;
    }

    public Date getStartTime() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        return this.starttime;
    }

    public TicketFlags getTicketFlags() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        return this.flags;
    }

    public String[] getTransited() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        return this.transited.getAsStringArray();
    }

    public void initDecrypt(EncryptionKey encryptionKey) throws KerberosException {
        if (encryptionKey == null) {
            throw new KerberosException("key is null");
        }
        int n = this.encPart.getEncryptionType();
        if (!KerberosCipher.checkEncType(n, encryptionKey.keyType())) {
            throw new KerberosException("key type mismatch");
        }
        this.cipher = KerberosCipher.getInstance(n, null);
        this.cipher.initDecrypt(encryptionKey, null);
    }

    public boolean isValid() throws NotYetDecryptedException {
        if (this.encTicketPart == null) {
            throw new NotYetDecryptedException("Ticket not yet decrypted");
        }
        Date date = new Date();
        if (this.starttime == null) {
            return date.before(this.endtime) && date.after(this.authtime);
        }
        return date.before(this.endtime) && date.after(this.starttime);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\nTicket:");
        stringBuffer.append("\n  encryption type: " + this.encryptionType());
        if (this.encTicketPart != null && this.decryptedOK) {
            stringBuffer.append(" (DECRYPTED OK) ");
        }
        stringBuffer.append("\n  service principal: " + this.getServerName() + "@" + this.getRealm());
        try {
            stringBuffer.append("\n  client: " + this.getClientName() + "@" + this.getClientRealm());
            stringBuffer.append("\n  session key: " + this.getKey());
            stringBuffer.append("\n  ticket flags: " + this.getTicketFlags());
            stringBuffer.append("\n  valid from: " + this.getAuthTime());
            stringBuffer.append("\n  valid till: " + this.getEndTime());
            stringBuffer.append("\n  valid for:");
            InetAddress[] inetAddressArray = this.getClientAddresses();
            if (inetAddressArray != null) {
                int n = 0;
                while (n < inetAddressArray.length) {
                    stringBuffer.append("\n    " + inetAddressArray[n]);
                    ++n;
                }
            } else {
                stringBuffer.append("\n    all addresses");
            }
            AuthorizationDataElement[] authorizationDataElementArray = this.getAuthData();
            if (authorizationDataElementArray != null) {
                stringBuffer.append("\n  auth data:");
                int n = 0;
                while (n < authorizationDataElementArray.length) {
                    stringBuffer.append("\n    " + authorizationDataElementArray[n]);
                    ++n;
                }
            }
        }
        catch (NotYetDecryptedException notYetDecryptedException) {}
        return stringBuffer.toString();
    }
}

