/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.crypto;

import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosKey;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DESKerberosKey
extends KerberosKey {
    public DESKerberosKey(int n, byte[] byArray) {
        super(n, byArray);
    }

    public DESKerberosKey(int n, byte[] byArray, byte[] byArray2) throws KerberosException {
        super(n, byArray, byArray2);
    }

    private static final void forceOddParity(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            int n3 = 7;
            while (n3 >= 0) {
                n2 += byArray[n] >>> n3 & 1;
                --n3;
            }
            if (n2 % 2 == 0) {
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] ^ 1);
            }
            ++n;
        }
    }

    protected byte[] stringToKey(byte[] byArray, byte[] byArray2) throws KerberosException {
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        try {
            int n = 0;
            while (n < byArray4.length) {
                byte by = byArray4[n];
                if (n % 16 < 8) {
                    int n2 = n % 8;
                    byArray3[n2] = (byte)(byArray3[n2] ^ by << 1);
                } else {
                    by = (byte)(by << 4 & 0xF0 | by >> 4 & 0xF);
                    by = (byte)(by << 2 & 0xCC | by >> 2 & 0x33);
                    by = (byte)(by << 1 & 0xAA | by >> 1 & 0x55);
                    int n3 = 7 - n % 8;
                    byArray3[n3] = (byte)(byArray3[n3] ^ by);
                }
                ++n;
            }
            DESKerberosKey.forceOddParity(byArray3);
            Mac mac = Mac.getInstance("DES-MAC");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, "DES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
            mac.init(secretKeySpec, ivParameterSpec);
            byArray3 = mac.doFinal(byArray4);
            mac.reset();
            DESKerberosKey.forceOddParity(byArray3);
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KerberosException("Provider  error: " + noSuchAlgorithmException.getMessage());
        }
        catch (Exception exception) {
            throw new KerberosException("Internal error: " + exception.getMessage());
        }
    }
}

