/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.kerberos.APOptions;
import com.dstc.security.kerberos.Checksum;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.KDCOptions;
import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.KerberosContext;
import com.dstc.security.kerberos.KerberosError;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.Ticket;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.creds.CredentialStore;
import com.dstc.security.kerberos.creds.KeyTab;
import com.dstc.security.kerberos.creds.KeyTabEntry;
import com.dstc.security.kerberos.gssapi.GSSCredential;
import com.dstc.security.kerberos.gssapi.GSSKrbException;
import com.dstc.security.kerberos.gssapi.GSSManager;
import com.dstc.security.kerberos.gssapi.GSSName;
import com.dstc.security.kerberos.gssapi.InitialToken;
import com.dstc.security.kerberos.gssapi.PerMessageToken;
import com.dstc.security.kerberos.gssapi.Token;
import com.dstc.security.kerberos.msg.APRep;
import com.dstc.security.kerberos.msg.APReq;
import com.dstc.security.kerberos.msg.KerberosMessage;
import com.dstc.security.kerberos.msg.KrbCred;
import com.dstc.security.kerberos.msg.KrbError;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

final class GSSContext
implements org.ietf.jgss.GSSContext {
    private static final int UNINITIALIZED = 0;
    private static final int CLIENT_AUTHENTICATED = 1;
    private static final int SERVER_AUTHENTICATED = 2;
    private static final int DELEG_FLAG = 1;
    private static final int MUTUAL_FLAG = 2;
    private static final int REPLAY_FLAG = 4;
    private static final int SEQUENCE_FLAG = 8;
    private static final int CONF_FLAG = 16;
    private static final int INTEG_FLAG = 32;
    private static final int ANON_FLAG = 64;
    private static final int PROT_READY_FLAG = 128;
    private static final int TRANS_FLAG = 256;
    private static final byte[] DES_MAC_MD5 = new byte[2];
    private static final byte[] DES_CBC = new byte[2];
    private static final byte[] NONE = new byte[]{-1, -1};
    private static final byte[] WRAP_FILLER = new byte[]{-1, -1};
    private static final byte[] MIC_FILLER = new byte[]{-1, -1, -1, -1};
    private static final byte[] INITIATOR = new byte[4];
    private static final byte[] ACCEPTOR = new byte[]{-1, -1, -1, -1};
    private static final int INT_LEN = 4;
    private static final int PAD_LEN = INITIATOR.length;
    private static final int ID_LEN = 2;
    private static final int ALG_LEN = NONE.length;
    private static final int SEQ_LEN = 4 + PAD_LEN;
    private static final int CKSUM_LEN = 8;
    private static final int KRB_CKSUM = 32771;
    private static final byte[] LGTH;
    private static final byte[] BND;
    private static final int FLAGS_LEN = 4;
    private static final byte[] DLGOPT;
    private static final int DLGTH_LEN = 2;
    private static final int KEY_MOD = 240;
    private static final int BLOCKSIZE = 8;
    private static final int MSEC_PER_SEC = 1000;
    private static final int BYTE_LEN = 8;
    private static final int ONES = 255;
    private static final int CLOCK_SKEW = 300000;
    private org.ietf.jgss.GSSName peer;
    private Oid mechanism;
    private org.ietf.jgss.GSSCredential cred;
    private int lifetime;
    private org.ietf.jgss.GSSCredential delegCred;
    private ChannelBinding cb;
    private long startTime;
    private long endTime;
    private boolean initiator;
    private int flags;
    private int state = 0;
    private int sndSeqNum = -1;
    private int rcvSeqNum = -1;
    private boolean protReady = false;
    private Kerberos kerberos;
    private EncryptionKey contextKey;
    private Date ctime;
    private SecretKey sessionKey;
    private SecureRandom rand;
    private Cipher cipher;
    private SecretKeyFactory keyFact;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 16;
        LGTH = byArray;
        BND = new byte[GSSContext.bytesToInt(LGTH)];
        byte[] byArray2 = new byte[2];
        byArray2[0] = 1;
        DLGOPT = byArray2;
    }

    private GSSContext() throws GSSException {
        try {
            this.cipher = Cipher.getInstance("DES/CBC/NoPadding");
            this.keyFact = SecretKeyFactory.getInstance("DES");
            this.rand = new SecureRandom();
            int n = this.rand.nextInt() / 10;
            this.sndSeqNum = n > 0 ? n : -n;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(13, -1, generalSecurityException.getMessage());
        }
    }

    GSSContext(org.ietf.jgss.GSSCredential gSSCredential, Kerberos kerberos) throws GSSException {
        this();
        if (gSSCredential == null) {
            this.cred = new GSSCredential(null, Integer.MAX_VALUE, null, 2, kerberos);
            this.lifetime = Integer.MAX_VALUE;
        } else if (gSSCredential.getUsage() != 1) {
            this.cred = gSSCredential;
            this.lifetime = this.cred.getRemainingLifetime();
        } else {
            throw new GSSException(7);
        }
        this.mechanism = GSSManager.KRB5;
        this.kerberos = kerberos;
        this.initiator = false;
    }

    GSSContext(org.ietf.jgss.GSSName gSSName, Oid oid, org.ietf.jgss.GSSCredential gSSCredential, int n, Kerberos kerberos) throws GSSException {
        this();
        if (oid != null && !oid.equals(GSSManager.KRB5)) {
            throw new GSSException(1);
        }
        this.mechanism = GSSManager.KRB5;
        if (gSSCredential == null) {
            this.cred = new GSSCredential(null, n, this.mechanism, 1, kerberos);
        } else if (gSSCredential.getUsage() != 2) {
            this.cred = gSSCredential;
        } else {
            throw new GSSException(7);
        }
        if (gSSName == null) {
            throw new GSSException(2);
        }
        this.peer = !gSSName.isMN() ? gSSName.canonicalize(GSSManager.KRB5) : gSSName;
        this.kerberos = kerberos;
        this.lifetime = n;
        this.initiator = true;
    }

    GSSContext(byte[] byArray, Kerberos kerberos) throws GSSException {
        this();
    }

    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        switch (this.state) {
            case 0: {
                try {
                    Object object;
                    Object object2;
                    KerberosContext kerberosContext = this.kerberos.getContext();
                    String string = this.cred.getName().toString();
                    KeyTab keyTab = kerberosContext.getKeyTab();
                    if (keyTab == null) {
                        KrbError krbError = Kerberos.createKrbError(45, string);
                        InitialToken.write(outputStream, Token.KRB_ERROR, krbError);
                        throw new KerberosError(45);
                    }
                    KeyTabEntry keyTabEntry = kerberosContext.getKeyTab().getKeyTabEntry(string);
                    if (keyTabEntry == null) {
                        KrbError krbError = Kerberos.createKrbError(45, string);
                        InitialToken.write(outputStream, Token.KRB_ERROR, krbError);
                        throw new GSSKrbException(13, 11);
                    }
                    KerberosMessage kerberosMessage = new InitialToken(inputStream).getKrbMessage();
                    if (!(kerberosMessage instanceof APReq)) {
                        KrbError krbError = Kerberos.createKrbError(40, string);
                        InitialToken.write(outputStream, Token.KRB_ERROR, krbError);
                        throw new KerberosError(40);
                    }
                    APReq aPReq = (APReq)kerberosMessage;
                    Ticket ticket = Kerberos.decryptTicket(keyTabEntry, aPReq.getTicket());
                    this.endTime = ticket.getEndTime().getTime();
                    this.contextKey = ticket.getKey();
                    aPReq = Kerberos.decryptApplicationRequest(this.contextKey, aPReq);
                    this.peer = new GSSName(aPReq.getClientName().toString(), GSSName.KRB5_NT_PRINCIPAL_NAME, this.kerberos);
                    byte[] byArray = aPReq.getChecksum().getBytes();
                    byte[] byArray2 = new byte[4];
                    int n = LGTH.length + BND.length;
                    System.arraycopy(byArray, n, byArray2, 0, 4);
                    this.flags = GSSContext.bytesToInt(byArray2);
                    n += 4;
                    if (this.getCredDelegState()) {
                        byArray2 = new byte[2];
                        System.arraycopy(byArray, n += DLGOPT.length, byArray2, 0, 2);
                        int n2 = GSSContext.bytesToInt(byArray2);
                        byArray2 = new byte[n2];
                        System.arraycopy(byArray, n += 2, byArray2, 0, n2);
                        kerberosMessage = Kerberos.getMessage(byArray2);
                        if (!(kerberosMessage instanceof KrbCred)) {
                            KrbError krbError = Kerberos.createKrbError(40, string);
                            InitialToken.write(outputStream, Token.KRB_ERROR, krbError);
                            throw new KerberosError(40);
                        }
                        KrbCred krbCred = Kerberos.decryptKrbCred(this.contextKey, (KrbCred)kerberosMessage);
                        object2 = krbCred.getTicketInfo()[0];
                        this.delegCred = new GSSCredential(this.peer, Integer.MAX_VALUE, GSSManager.KRB5, 1, this.kerberos);
                    }
                    this.startTime = System.currentTimeMillis();
                    long l = aPReq.getClientTime().getTime();
                    if (l < this.startTime - 300000L || l > this.startTime + 300000L) {
                        object2 = Kerberos.createKrbError(37, string);
                        InitialToken.write(outputStream, Token.KRB_ERROR, (KerberosMessage)object2);
                        throw new KerberosError(37);
                    }
                    this.state = 1;
                    this.rcvSeqNum = aPReq.getSequenceNumber();
                    object2 = aPReq.getAPOptions();
                    if (this.getMutualAuthState() && ((APOptions)object2).mutualRequired()) {
                        object = Kerberos.createApplicationResponse(this.contextKey, aPReq.getClientTime(), aPReq.getCusec(), this.sndSeqNum, null);
                        InitialToken.write(outputStream, Token.KRB_AP_REP, (KerberosMessage)object);
                    }
                    this.sessionKey = (object = aPReq.getSubKey()) != null ? this.keyFact.generateSecret(new DESKeySpec(object.keyValue())) : this.keyFact.generateSecret(new DESKeySpec(this.contextKey.keyValue()));
                    this.protReady = true;
                    break;
                }
                catch (IOException iOException) {
                    throw new GSSException(13, -1, iOException.toString());
                }
                catch (KerberosException kerberosException) {
                    throw new GSSException(13, -1, kerberosException.toString());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new GSSException(13, -1, generalSecurityException.toString());
                }
            }
            case 1: {
                throw new GSSKrbException(5, 14);
            }
            default: {
                throw new GSSException(13);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayInputStream byteArrayInputStream;
        block8: {
            byte[] byArray3;
            block7: {
                byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
                byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    this.acceptSecContext(byteArrayInputStream, byteArrayOutputStream);
                    if (byteArrayOutputStream.size() == 0) {
                        byArray3 = null;
                        Object var8_8 = null;
                        break block7;
                    }
                    byArray2 = byteArrayOutputStream.toByteArray();
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new GSSException(13, -1, iOException.toString());
                    }
                }
            }
            try {}
            catch (IOException iOException) {
                throw new GSSException(13, -1, iOException.toString());
            }
            GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
            return byArray3;
        }
        Object var8_9 = null;
        try {}
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.toString());
        }
        GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
        return byArray2;
    }

    private static int bytesToInt(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (--n >= 0) {
            n2 <<= 8;
            n2 |= byArray[n] & 0xFF;
        }
        return n2;
    }

    private static void close(InputStream inputStream, OutputStream outputStream) throws IOException {
        block4: {
            try {
                if (inputStream == null) break block4;
                inputStream.close();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (outputStream != null) {
                    outputStream.close();
                }
                throw throwable;
            }
        }
        Object var3_2 = null;
        if (outputStream != null) {
            outputStream.close();
        }
    }

    private byte[] computeChecksum(byte[] byArray, byte[] byArray2) throws GSSException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            this.cipher.init(1, (Key)this.sessionKey, new IvParameterSpec(new byte[8]), this.rand);
            byte[] byArray3 = this.cipher.doFinal(messageDigest.digest());
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray3, 8, byArray4, 0, 8);
            return byArray4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(13, -1, generalSecurityException.toString());
        }
    }

    private void decryptSeq(byte[] byArray, byte[] byArray2, MessageProp messageProp) throws GSSException {
        byte[] byArray3;
        byte[] byArray4;
        try {
            this.cipher.init(2, (Key)this.sessionKey, new IvParameterSpec(byArray), this.rand);
            byArray4 = this.cipher.doFinal(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(6, -1, generalSecurityException.toString());
        }
        byte[] byArray5 = new byte[4];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray5.length);
        int n = GSSContext.bytesToInt(byArray5);
        if (this.getSequenceDetState()) {
            if (n < this.rcvSeqNum) {
                throw new GSSException(21);
            }
            if (n > this.rcvSeqNum) {
                throw new GSSException(22);
            }
        }
        if (this.getReplayDetState() && this.rcvSeqNum - 1 == n) {
            throw new GSSException(19);
        }
        ++this.rcvSeqNum;
        byte[] byArray6 = new byte[PAD_LEN];
        System.arraycopy(byArray4, 4, byArray6, 0, byArray6.length);
        byte[] byArray7 = byArray3 = this.initiator ? ACCEPTOR : INITIATOR;
        if (!Arrays.equals(byArray3, byArray6)) {
            throw new GSSException(6);
        }
    }

    public void dispose() throws GSSException {
        if (this.cred != null) {
            this.cred.dispose();
            this.cred = null;
        }
        if (this.delegCred != null) {
            this.delegCred.dispose();
            this.delegCred = null;
        }
        this.contextKey = null;
        this.sessionKey = null;
    }

    public byte[] export() throws GSSException {
        throw new UnsupportedOperationException();
    }

    public boolean getAnonymityState() {
        return this.state < 1;
    }

    public boolean getConfState() {
        return (this.flags & 0x10) == 16;
    }

    public boolean getCredDelegState() {
        return (this.flags & 1) == 1;
    }

    public org.ietf.jgss.GSSCredential getDelegCred() throws GSSException {
        if (!this.isEstablished()) {
            throw new GSSKrbException(13, 17);
        }
        return this.delegCred;
    }

    public boolean getIntegState() {
        return (this.flags & 0x20) == 32;
    }

    public int getLifetime() {
        if (!this.isEstablished() || !this.isProtReady()) {
            return this.lifetime;
        }
        int n = (int)((this.endTime - System.currentTimeMillis()) / 1000L);
        return n < 0 ? 0 : n;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new GSSKrbException(13, 17);
        }
        if (this.getLifetime() == 0) {
            throw new GSSException(12);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byte[] byArray = new byte[inputStream.available()];
                inputStream.read(byArray);
                byteArrayOutputStream.write(Token.MIC);
                byteArrayOutputStream.write(DES_MAC_MD5);
                byteArrayOutputStream.write(MIC_FILLER);
                byte[] byArray2 = this.computeChecksum(byteArrayOutputStream.toByteArray(), byArray);
                this.writeSeqNum(byteArrayOutputStream, byArray2);
                byteArrayOutputStream.write(byArray2);
                messageProp.setQOP(2);
                PerMessageToken.write(outputStream, byteArrayOutputStream);
            }
            finally {
                Object var6_9 = null;
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(13, -1, generalSecurityException.toString());
        }
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.getMIC(byteArrayInputStream, byteArrayOutputStream, messageProp);
            if (byteArrayOutputStream.size() == 0) {
                throw new GSSException(13);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new GSSException(13, -1, iOException.toString());
            }
            throw throwable;
        }
        try {
            GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.toString());
        }
        return byArray2;
    }

    public Oid getMech() throws GSSException {
        return this.mechanism;
    }

    public boolean getMutualAuthState() {
        return (this.flags & 2) == 2;
    }

    public boolean getReplayDetState() {
        return (this.flags & 4) == 4;
    }

    public boolean getSequenceDetState() {
        return (this.flags & 8) == 8;
    }

    public org.ietf.jgss.GSSName getSrcName() throws GSSException {
        if (!this.isEstablished() && !this.isProtReady()) {
            throw new GSSKrbException(13, 17);
        }
        return this.initiator ? this.cred.getName() : this.peer;
    }

    public org.ietf.jgss.GSSName getTargName() throws GSSException {
        if (!this.isEstablished() && !this.isProtReady()) {
            throw new GSSKrbException(13, 17);
        }
        return this.initiator ? this.peer : this.cred.getName();
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        return Integer.MAX_VALUE;
    }

    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        switch (this.state) {
            case 0: {
                try {
                    APReq aPReq;
                    Object object;
                    Object object2;
                    KerberosContext kerberosContext = this.kerberos.getContext();
                    String string = this.peer.toString();
                    CredentialStore credentialStore = kerberosContext.getCredentialStore();
                    if (credentialStore == null) {
                        throw new GSSException(13, -1, "kerberos credential store not set");
                    }
                    Credential credential = credentialStore.getCredential(string);
                    if (credential == null || !credential.isValid()) {
                        int n = string.lastIndexOf(64);
                        if (n == -1) {
                            throw new KerberosException("Expecting fully qualified  Kerberos name");
                        }
                        object2 = string.substring(n + 1);
                        object = new PrincipalName(3, string.substring(0, n));
                        credential = this.kerberos.requestServiceTicket(credentialStore.getTGTCredential(kerberosContext.getRealm()), (PrincipalName)object, (String)object2, new KDCOptions());
                    }
                    this.endTime = credential.getEndTime().getTime();
                    this.contextKey = credential.getSessionKey();
                    this.sessionKey = this.keyFact.generateSecret(new DESKeySpec(this.contextKey.keyValue()));
                    this.requestInteg(true);
                    if (this.getSequenceDetState()) {
                        this.requestMutualAuth(true);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        byteArrayOutputStream.write(LGTH);
                        byteArrayOutputStream.write(BND);
                        byteArrayOutputStream.write(GSSContext.intToBytes(this.flags));
                        if (this.getCredDelegState()) {
                            String string2 = kerberosContext.getRealm();
                            String string3 = "krbtgt/" + string2;
                            KDCOptions kDCOptions = new KDCOptions();
                            kDCOptions.setForwardable();
                            PrincipalName principalName = new PrincipalName(3, string3);
                            Credential credential2 = this.kerberos.requestServiceTicket(credentialStore.getTGTCredential(string2), principalName, string2, kDCOptions);
                            Credential[] credentialArray = new Credential[]{credential2};
                            byte[] byArray = Kerberos.createKrbCred(this.contextKey, credentialArray).getEncoded();
                            byteArrayOutputStream.write(DLGOPT);
                            byteArrayOutputStream.write(GSSContext.intToBytes(byArray.length), 0, 2);
                            byteArrayOutputStream.write(byArray);
                        }
                        object2 = byteArrayOutputStream.toByteArray();
                    }
                    finally {
                        aPReq = null;
                        if (byteArrayOutputStream != null) {
                            byteArrayOutputStream.close();
                        }
                    }
                    object = new APOptions();
                    if (this.getMutualAuthState()) {
                        ((APOptions)object).setMutualRequired();
                    }
                    aPReq = Kerberos.createApplicationRequest(credential, (APOptions)object, this.sndSeqNum, new Checksum(32771, (byte[])object2), null);
                    this.startTime = aPReq.getClientTime().getTime();
                    this.ctime = new Date(this.startTime);
                    InitialToken.write(outputStream, Token.KRB_AP_REQ, aPReq);
                }
                catch (IOException iOException) {
                    throw new GSSException(13, -1, iOException.toString());
                }
                catch (KerberosException kerberosException) {
                    throw new GSSException(13, -1, kerberosException.toString());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new GSSException(13, -1, generalSecurityException.toString());
                }
                this.state = 1;
                if (this.getMutualAuthState()) break;
                this.protReady = true;
                break;
            }
            case 1: {
                try {
                    KerberosMessage kerberosMessage = new InitialToken(inputStream).getKrbMessage();
                    if (!(kerberosMessage instanceof APRep)) {
                        if (!(kerberosMessage instanceof KrbError)) {
                            throw new KerberosError(40);
                        }
                        throw new KerberosError(((KrbError)kerberosMessage).getErrorCode());
                    }
                    APRep aPRep = Kerberos.decryptApplicationResponse(this.contextKey, (APRep)kerberosMessage);
                    this.rcvSeqNum = aPRep.getSequenceNumber();
                    EncryptionKey encryptionKey = aPRep.getSubSessionKey();
                    if (encryptionKey != null) {
                        this.sessionKey = new SecretKeySpec(encryptionKey.keyValue(), "DES");
                    }
                    if (!this.ctime.equals(aPRep.getClientTime())) {
                        throw new KerberosError(46);
                    }
                }
                catch (IOException iOException) {
                    throw new GSSException(9, -1, iOException.toString());
                }
                catch (KerberosException kerberosException) {
                    throw new GSSException(13, -1, kerberosException.toString());
                }
                this.state = 2;
                this.protReady = true;
                break;
            }
            case 2: {
                throw new GSSKrbException(5, 14);
            }
            default: {
                throw new GSSException(13);
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayInputStream byteArrayInputStream;
        block8: {
            byte[] byArray3;
            block7: {
                byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
                byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    this.initSecContext(byteArrayInputStream, byteArrayOutputStream);
                    if (byteArrayOutputStream.size() == 0) {
                        byArray3 = null;
                        Object var8_8 = null;
                        break block7;
                    }
                    byArray2 = byteArrayOutputStream.toByteArray();
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new GSSException(13, -1, iOException.toString());
                    }
                }
            }
            try {}
            catch (IOException iOException) {
                throw new GSSException(13, -1, iOException.toString());
            }
            GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
            return byArray3;
        }
        Object var8_9 = null;
        try {}
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.toString());
        }
        GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
        return byArray2;
    }

    private static byte[] intToBytes(int n) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        int n3 = byArray.length;
        while (n2 < n3) {
            byArray[n2] = (byte)(n & 0xFF);
            n >>>= 8;
            ++n2;
        }
        return byArray;
    }

    public boolean isEstablished() {
        if (this.initiator && this.getMutualAuthState()) {
            return this.state == 2;
        }
        return this.state == 1;
    }

    public boolean isInitiator() throws GSSException {
        if (this.state == 0) {
            throw new GSSException(13);
        }
        return this.initiator;
    }

    public boolean isProtReady() {
        return this.protReady;
    }

    public boolean isTransferable() throws GSSException {
        if (!this.isEstablished()) {
            throw new GSSKrbException(13, 17);
        }
        return (this.flags & 0x100) == 256;
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.state != 0 || !this.initiator || bl) {
            throw new GSSException(13);
        }
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.state != 0 || !this.initiator) {
            throw new GSSException(13);
        }
        if (bl) {
            this.flags |= 0x10;
        }
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.state != 0 || !this.initiator) {
            throw new GSSException(13);
        }
        if (bl) {
            this.flags |= 1;
        }
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.state != 0 || !this.initiator || !bl) {
            throw new GSSException(13);
        }
        this.flags |= 0x20;
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.state != 0 || !this.initiator) {
            throw new GSSException(13);
        }
        this.lifetime = n;
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.state != 0 || !this.initiator) {
            throw new GSSException(13);
        }
        if (bl) {
            this.flags |= 2;
        }
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.state != 0 || !this.initiator) {
            throw new GSSException(13);
        }
        if (bl) {
            this.flags |= 4;
        }
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.state != 0 || !this.initiator) {
            throw new GSSException(13);
        }
        if (bl) {
            this.flags |= 8;
        }
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        if (this.state != 0) {
            throw new GSSException(13);
        }
        this.cb = channelBinding;
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new GSSKrbException(13, 17);
        }
        if (this.getLifetime() == 0) {
            throw new GSSException(12);
        }
        try {
            int n;
            byte[] byArray;
            byte[] byArray2;
            byte[] byArray3;
            try {
                byArray3 = new PerMessageToken(inputStream).getInnerToken();
                if (byArray3 == null) {
                    throw new GSSException(9);
                }
            }
            catch (IOException iOException) {
                throw new GSSException(9, -1, iOException.toString());
            }
            int n2 = 0;
            n2 += 2;
            byte[] byArray4 = new byte[ALG_LEN];
            System.arraycopy(byArray3, n2 += ALG_LEN, byArray4, 0, byArray4.length);
            n2 += ALG_LEN;
            byte[] byArray5 = new byte[SEQ_LEN];
            System.arraycopy(byArray3, n2 += WRAP_FILLER.length, byArray5, 0, byArray5.length);
            byte[] byArray6 = new byte[8];
            System.arraycopy(byArray3, n2 += SEQ_LEN, byArray6, 0, byArray6.length);
            byte[] byArray7 = new byte[byArray3.length - (n2 += 8)];
            System.arraycopy(byArray3, n2, byArray7, 0, byArray7.length);
            if (Arrays.equals(byArray4, NONE)) {
                byArray2 = byArray7;
                messageProp.setQOP(0);
                messageProp.setPrivacy(false);
            } else {
                byArray = new byte[8];
                n = 0;
                while (n < byArray.length) {
                    byArray[n] = (byte)(this.sessionKey.getEncoded()[n] ^ 0xFFFFFFF0);
                    ++n;
                }
                this.cipher.init(2, (Key)this.keyFact.generateSecret(new DESKeySpec(byArray)), new IvParameterSpec(new byte[8]), this.rand);
                byArray2 = this.cipher.doFinal(byArray7);
                messageProp.setQOP(0);
                messageProp.setPrivacy(true);
            }
            byArray = new byte[8];
            System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
            if (!Arrays.equals(byArray6, this.computeChecksum(byArray, byArray2))) {
                throw new GSSException(6);
            }
            this.decryptSeq(byArray6, byArray5, messageProp);
            n = byArray2.length;
            byte[] byArray8 = new byte[n - byArray2[n - 1] - 8];
            System.arraycopy(byArray2, 8, byArray8, 0, byArray8.length);
            outputStream.write(byArray8);
        }
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(13, -1, generalSecurityException.toString());
        }
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.unwrap(byteArrayInputStream, byteArrayOutputStream, messageProp);
            if (byteArrayOutputStream.size() == 0) {
                throw new GSSException(13);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new GSSException(13, -1, iOException.toString());
            }
            throw throwable;
        }
        try {
            GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.toString());
        }
        return byArray2;
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new GSSKrbException(13, 17);
        }
        if (this.getLifetime() == 0) {
            throw new GSSException(12);
        }
        try {
            byte[] byArray;
            try {
                byArray = new PerMessageToken(inputStream).getInnerToken();
                if (byArray == null) {
                    throw new GSSException(9);
                }
            }
            catch (IOException iOException) {
                throw new GSSException(9, -1, iOException.toString());
            }
            byte[] byArray2 = new byte[inputStream2.available()];
            inputStream2.read(byArray2);
            int n = 0;
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray, n, byArray3, 0, byArray3.length);
            n += 2;
            n += ALG_LEN;
            byte[] byArray4 = new byte[SEQ_LEN];
            System.arraycopy(byArray, n += MIC_FILLER.length, byArray4, 0, byArray4.length);
            byte[] byArray5 = new byte[8];
            System.arraycopy(byArray, n += SEQ_LEN, byArray5, 0, byArray5.length);
            if (!Arrays.equals(byArray5, this.computeChecksum(byArray3, byArray2))) {
                throw new GSSException(6);
            }
            this.decryptSeq(byArray5, byArray4, messageProp);
            messageProp.setQOP(0);
            messageProp.setPrivacy(false);
        }
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.toString());
        }
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2, n3, n4);
        try {
            this.verifyMIC(byteArrayInputStream, byteArrayInputStream2, messageProp);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    throw new GSSException(13, -1, iOException.toString());
                }
                {
                }
            }
            finally {
                Object v0 = null;
            }
        }
        Object var11_10 = null;
        try {
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new GSSException(13, -1, iOException.toString());
            }
            {
            }
        }
        finally {
            Object v1 = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        Object object;
        if (!this.isProtReady()) {
            throw new GSSKrbException(13, 17);
        }
        if (this.getLifetime() == 0) {
            throw new GSSException(12);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            try {
                object = new byte[inputStream.available()];
                inputStream.read((byte[])object);
                byteArrayOutputStream.write(Token.WRAP);
                byteArrayOutputStream.write(DES_MAC_MD5);
                byteArrayOutputStream.write(this.getConfState() && messageProp.getPrivacy() ? DES_CBC : NONE);
                byteArrayOutputStream.write(WRAP_FILLER);
                int n = ((byte[])object).length % 8;
                int n2 = n != 0 ? 8 - n : 8;
                byte[] byArray = new byte[8];
                byte[] byArray2 = new byte[((byte[])object).length + 8 + n2];
                System.arraycopy(byArray, 0, byArray2, 0, 8);
                System.arraycopy(object, 0, byArray2, 8, ((byte[])object).length);
                int n3 = 0;
                while (n3 < n2) {
                    byArray2[((byte[])object).length + 8 + n3] = (byte)n2;
                    ++n3;
                }
                byte[] byArray3 = this.computeChecksum(byteArrayOutputStream.toByteArray(), byArray2);
                this.writeSeqNum(byteArrayOutputStream, byArray3);
                byteArrayOutputStream.write(byArray3);
                if (this.getConfState() && messageProp.getPrivacy()) {
                    byte[] byArray4 = new byte[8];
                    int n4 = 0;
                    while (n4 < byArray4.length) {
                        byArray4[n4] = (byte)(this.sessionKey.getEncoded()[n4] ^ 0xFFFFFFF0);
                        ++n4;
                    }
                    this.cipher.init(1, (Key)this.keyFact.generateSecret(new DESKeySpec(byArray4)), new IvParameterSpec(new byte[8]), this.rand);
                    byte[] byArray5 = this.cipher.doFinal(byArray2);
                    byteArrayOutputStream.write(byArray5);
                    messageProp.setQOP(0);
                    messageProp.setPrivacy(true);
                } else {
                    byteArrayOutputStream.write(byArray2);
                    messageProp.setQOP(0);
                    messageProp.setPrivacy(false);
                }
                PerMessageToken.write(outputStream, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new GSSException(13, -1, iOException.toString());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new GSSException(13, -1, generalSecurityException.toString());
            }
            Object var6_18 = null;
        }
        catch (Throwable throwable) {
            Object var6_19 = null;
            try {
                if (byteArrayOutputStream == null) throw throwable;
                byteArrayOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new GSSException(13, -1, iOException.toString());
            }
        }
        try {
            if (byteArrayOutputStream == null) return;
            byteArrayOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            throw new GSSException(13, -1, ((Throwable)object).toString());
        }
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.wrap(byteArrayInputStream, byteArrayOutputStream, messageProp);
            if (byteArrayOutputStream.size() == 0) {
                throw new GSSException(13);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new GSSException(13, -1, iOException.toString());
            }
            throw throwable;
        }
        try {
            GSSContext.close(byteArrayInputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.toString());
        }
        return byArray2;
    }

    private void writeSeqNum(OutputStream outputStream, byte[] byArray) throws IOException, GeneralSecurityException {
        this.cipher.init(1, (Key)this.sessionKey, new IvParameterSpec(byArray), this.rand);
        byte[] byArray2 = GSSContext.intToBytes(this.sndSeqNum);
        ++this.sndSeqNum;
        byte[] byArray3 = this.initiator ? INITIATOR : ACCEPTOR;
        int n = byArray2.length + byArray3.length;
        int n2 = this.cipher.getOutputSize(n);
        byte[] byArray4 = new byte[n2];
        int n3 = 0;
        n3 += this.cipher.update(byArray2, 0, byArray2.length, byArray4, n3);
        n3 += this.cipher.doFinal(byArray3, 0, byArray3.length, byArray4, n3);
        outputStream.write(byArray4, 0, n3);
    }
}

