/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.gssapi.GSSManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

final class GSSName
implements org.ietf.jgss.GSSName {
    static final Oid KRB5_NT_PRINCIPAL_NAME = GSSManager.KRB5_NT_PRINCIPAL_NAME;
    private String nameString;
    private Oid nameType;
    private Oid mechanism;
    private Kerberos kerberos;
    private PrincipalName kerberosName;

    GSSName(String string, Oid oid, Kerberos kerberos) throws GSSException {
        if (string == null) {
            throw new GSSException(2);
        }
        this.nameString = string;
        if (oid == null) {
            this.nameType = org.ietf.jgss.GSSName.NT_USER_NAME;
        } else if (!oid.equals(org.ietf.jgss.GSSName.NT_EXPORT_NAME) && oid.containedIn(GSSManager.TYPES)) {
            this.nameType = oid;
        } else {
            throw new GSSException(3);
        }
        this.kerberos = kerberos;
        if (this.nameType.equals(KRB5_NT_PRINCIPAL_NAME)) {
            this.makeKerberosName();
        } else if (this.nameType.equals(org.ietf.jgss.GSSName.NT_HOSTBASED_SERVICE) && this.nameString.indexOf(64) == -1) {
            try {
                this.nameString = String.valueOf(this.nameString) + "@" + InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                throw new GSSException(13, -1, unknownHostException.toString());
            }
        }
    }

    GSSName(byte[] byArray, Oid oid, Kerberos kerberos) throws GSSException {
        if (byArray == null) {
            throw new GSSException(2);
        }
        if (oid != null && !oid.equals(org.ietf.jgss.GSSName.NT_EXPORT_NAME)) {
            throw new GSSException(3);
        }
        try {
            this.kerberosName = new PrincipalName(byArray);
        }
        catch (KerberosException kerberosException) {
            throw new GSSException(2, -1, kerberosException.toString());
        }
        String[] stringArray = this.kerberosName.nameComponents();
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        int n2 = stringArray.length;
        while (n < n2) {
            stringBuffer.append("/");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        stringBuffer.append("@");
        stringBuffer.append(kerberos.getContext().getRealm());
        this.nameString = stringBuffer.toString();
        switch (this.kerberosName.nameType()) {
            case 1: {
                this.nameType = KRB5_NT_PRINCIPAL_NAME;
                break;
            }
            case 3: {
                this.nameType = org.ietf.jgss.GSSName.NT_HOSTBASED_SERVICE;
                break;
            }
            default: {
                throw new GSSException(3);
            }
        }
        this.mechanism = GSSManager.KRB5;
        this.kerberos = kerberos;
    }

    public org.ietf.jgss.GSSName canonicalize(Oid oid) throws GSSException {
        if (oid == null || !oid.equals(GSSManager.KRB5)) {
            throw new GSSException(1);
        }
        if (this.isMN()) {
            return this;
        }
        GSSName gSSName = new GSSName(this.nameString, this.nameType, this.kerberos);
        gSSName.makeKerberosName();
        return gSSName;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof org.ietf.jgss.GSSName) {
            try {
                return this.equals((org.ietf.jgss.GSSName)object);
            }
            catch (GSSException gSSException) {
            }
        }
        return false;
    }

    public boolean equals(org.ietf.jgss.GSSName gSSName) throws GSSException {
        if (gSSName == null || this.isAnonymous() || gSSName.isAnonymous()) {
            return false;
        }
        if (!this.getStringNameType().equals(gSSName.getStringNameType())) {
            throw new GSSException(3);
        }
        return this.toString().equals(gSSName.toString());
    }

    public byte[] export() throws GSSException {
        if (!this.isMN()) {
            throw new GSSException(18);
        }
        try {
            return this.kerberosName.getEncoded();
        }
        catch (KerberosException kerberosException) {
            throw new GSSException(2, -1, kerberosException.toString());
        }
    }

    public Oid getStringNameType() throws GSSException {
        return this.nameType;
    }

    public int hashCode() {
        try {
            return this.toString().hashCode() ^ this.getStringNameType().hashCode();
        }
        catch (GSSException gSSException) {
            return 0;
        }
    }

    public boolean isAnonymous() {
        return this.nameType.equals(org.ietf.jgss.GSSName.NT_ANONYMOUS);
    }

    public boolean isMN() {
        return this.mechanism != null;
    }

    private void makeKerberosName() throws GSSException {
        if (this.nameType.equals(org.ietf.jgss.GSSName.NT_HOSTBASED_SERVICE)) {
            this.nameString = this.nameString.replace('@', '/');
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.nameString, "/");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        if (this.nameType.equals(org.ietf.jgss.GSSName.NT_HOSTBASED_SERVICE)) {
            this.kerberosName = new PrincipalName(3, stringArray);
        } else if (this.nameType.equals(org.ietf.jgss.GSSName.NT_USER_NAME) || this.nameType.equals(KRB5_NT_PRINCIPAL_NAME)) {
            this.kerberosName = new PrincipalName(1, stringArray);
        } else {
            throw new GSSException(3);
        }
        if (this.nameString.indexOf(64) == -1) {
            this.nameString = String.valueOf(this.nameString) + "@" + this.kerberos.getContext().getRealm();
        }
        this.mechanism = GSSManager.KRB5;
    }

    public String toString() {
        return this.nameString;
    }
}

