/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.gssapi.GSSManager;
import com.dstc.security.kerberos.gssapi.Token;
import com.dstc.security.kerberos.msg.KerberosMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class InitialToken
extends Token {
    private KerberosMessage krbMessage;

    InitialToken(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new IOException("Unexpected EOF encountered");
        }
        this.readLength(inputStream);
        if (this.length != 0) {
            Oid oid = (Oid)Asn1.getAsn1(inputStream);
            this.tokenId = new byte[2];
            inputStream.read(this.tokenId);
            try {
                this.krbMessage = Kerberos.getMessage(Asn1.getAsn1(inputStream).getEncoded());
            }
            catch (Asn1Exception asn1Exception) {
                throw new IOException(asn1Exception.getMessage());
            }
            catch (KerberosException kerberosException) {
                throw new IOException(kerberosException.getMessage());
            }
        }
    }

    KerberosMessage getKrbMessage() {
        return this.krbMessage;
    }

    static void write(OutputStream outputStream, byte[] byArray, KerberosMessage kerberosMessage) throws IOException, KerberosException {
        byte[] byArray2 = null;
        try {
            byArray2 = GSSManager.KRB5.getDER();
        }
        catch (Exception exception) {}
        byte[] byArray3 = kerberosMessage.getEncoded();
        byte[] byArray4 = Token.toLengthOctets(byArray2.length + byArray.length + byArray3.length);
        outputStream.write(96);
        outputStream.write(byArray4);
        outputStream.write(byArray2);
        outputStream.write(byArray);
        outputStream.write(byArray3);
        outputStream.flush();
    }
}

