/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import java.io.IOException;
import java.io.InputStream;

abstract class Token {
    static final int TAG = 96;
    static final byte[] KRB_AP_REQ;
    static final byte[] KRB_AP_REP;
    static final byte[] KRB_ERROR;
    static final byte[] MIC;
    static final byte[] WRAP;
    static final byte[] DEL_CTX;
    static final int ID_LEN = 2;
    protected int length;
    protected byte[] tokenId;
    protected byte[] contents;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 1;
        KRB_AP_REQ = byArray;
        byte[] byArray2 = new byte[2];
        byArray2[0] = 2;
        KRB_AP_REP = byArray2;
        byte[] byArray3 = new byte[2];
        byArray3[0] = 3;
        KRB_ERROR = byArray3;
        MIC = new byte[]{1, 1};
        WRAP = new byte[]{2, 1};
        DEL_CTX = new byte[]{1, 2};
    }

    Token() {
    }

    private static final int bytesToInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = n3 << 8 | byArray[n4 + n] & 0xFF;
            ++n4;
        }
        return n3;
    }

    byte[] getTokenId() {
        return this.tokenId;
    }

    private static final byte[] intToBytes(int n) {
        int n2 = (Integer.toHexString(n).length() + 1) / 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)(n >>> 8 * (n2 - 1 - n3) & 0xFF);
            ++n3;
        }
        return byArray;
    }

    protected void readLength(InputStream inputStream) throws IOException {
        byte by = (byte)(inputStream.read() & 0xFF);
        if ((by & 0x80) == 0) {
            this.length = by;
        } else {
            byte[] byArray = new byte[by & 0x7F];
            inputStream.read(byArray);
            this.length = Token.bytesToInt(byArray, 0, byArray.length);
        }
    }

    protected static final byte[] toLengthOctets(int n) {
        byte[] byArray = null;
        if (n < 128) {
            byArray = new byte[]{(byte)n};
        } else {
            byte[] byArray2 = Token.intToBytes(n);
            byArray = new byte[1 + byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 1, byArray2.length);
            byArray[0] = (byte)(byArray2.length | 0x80);
        }
        return byArray;
    }
}

