/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

public class GSSException
extends Exception {
    public static final int BAD_MECH = 1;
    public static final int BAD_NAME = 2;
    public static final int BAD_NAMETYPE = 3;
    public static final int BAD_BINDINGS = 4;
    public static final int BAD_STATUS = 5;
    public static final int BAD_MIC = 6;
    public static final int NO_CRED = 7;
    public static final int NO_CONTEXT = 8;
    public static final int DEFECTIVE_TOKEN = 9;
    public static final int DEFECTIVE_CREDENTIAL = 10;
    public static final int CREDENTIALS_EXPIRED = 11;
    public static final int CONTEXT_EXPIRED = 12;
    public static final int FAILURE = 13;
    public static final int BAD_QOP = 14;
    public static final int UNAUTHORIZED = 15;
    public static final int UNAVAILABLE = 16;
    public static final int DUPLICATE_ELEMENT = 17;
    public static final int NAME_NOT_MN = 18;
    public static final int DUPLICATE_TOKEN = 19;
    public static final int OLD_TOKEN = 20;
    public static final int UNSEQ_TOKEN = 21;
    public static final int GAP_TOKEN = 22;
    private static final String[] ERROR_MSGS = new String[]{"No error", "Unsupported mechanism requested error.", "Invalid name provided error.", "Name of unsupported type provided error.", "Channel bindings mismatch error.", "Invalid status code error - this is the default status value.", "Token had invalid integrity check error.", "Invalid credentials error.", "Invalid security context error.", "Defective token error.", "Defective credential error.", "Expired credentials detected error.", "Specified security context expired error.", "General failure, unspecified at GSS-API level.", "Unsupported QOP value error.", "Operation unauthorized error.", "Operation unavailable error.", "Duplicate credential element requested error.", "Name contains multi-mechanism elements error."};
    private static final String[] INFORM_MSGS = new String[]{"Duplicate per-message token detected.", "Timed-out per-message token detected.", "Re-ordered (early) per-message token detected.", "Skipped predecessor token(s) detected."};
    private static final int MIN_ERR_CODE = 1;
    private static final int MAX_ERR_CODE = 18;
    private static final int MAX_INFORM_CODE = 22;
    private int majorCode;
    protected int minorCode;
    protected String minorString;

    public GSSException(int n) {
        this.majorCode = n;
    }

    public GSSException(int n, int n2, String string) {
        this(n);
        this.setMinor(n2, string);
    }

    public int getMajor() {
        return this.majorCode;
    }

    public String getMajorString() {
        if (this.majorCode < 1) {
            return "Unknown major code: " + this.majorCode;
        }
        if (this.majorCode <= 18) {
            return ERROR_MSGS[this.majorCode];
        }
        if (this.majorCode <= 22) {
            return INFORM_MSGS[this.majorCode - 18 - 1];
        }
        return "Unknown major code: " + this.majorCode;
    }

    public String getMessage() {
        if (this.minorString == null) {
            return this.getMajorString();
        }
        return String.valueOf(this.getMajorString()) + System.getProperty("line.separator") + this.minorString;
    }

    public int getMinor() {
        return this.minorCode;
    }

    public String getMinorString() {
        return this.minorString;
    }

    public void setMinor(int n, String string) {
        this.minorCode = n;
        this.minorString = string;
    }

    public String toString() {
        return super.toString();
    }
}

