/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.certpath.CertPathException;
import com.dstc.security.certpath.X509CertChecker;
import com.dstc.security.ssl.CertChecker;
import com.dstc.security.ssl.CertPathValidationException;
import com.dstc.security.ssl.TrustEngine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class BasicTrustEngine
extends TrustEngine {
    private final com.dstc.security.certpath.TrustEngine trustEngine;
    private final X509CertChecker checker;

    public BasicTrustEngine(Collection collection) {
        this(collection, null);
    }

    public BasicTrustEngine(Collection collection, CertChecker certChecker) {
        this.trustEngine = new com.dstc.security.certpath.TrustEngine(new Vector(collection));
        this.checker = BasicTrustEngine.wrap(certChecker);
    }

    public BasicTrustEngine(X509Certificate[] x509CertificateArray) {
        this(x509CertificateArray, null);
    }

    public BasicTrustEngine(X509Certificate[] x509CertificateArray, CertChecker certChecker) {
        this.trustEngine = new com.dstc.security.certpath.TrustEngine(x509CertificateArray);
        this.checker = BasicTrustEngine.wrap(certChecker);
    }

    public static Collection getCertificates(InputStream inputStream) throws CertificateException, IOException {
        inputStream = BasicTrustEngine.markableInputStream(inputStream);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        while (!BasicTrustEngine.isEOF(inputStream)) {
            arrayList.add(certificateFactory.generateCertificate(inputStream));
        }
        return arrayList;
    }

    public static Collection getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            if (!(certificate instanceof X509Certificate)) continue;
            arrayList.add(certificate);
        }
        return arrayList;
    }

    public static BasicTrustEngine getDefault() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        String string = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        keyStore.load(new FileInputStream(string), null);
        return new BasicTrustEngine(BasicTrustEngine.getCertificates(keyStore));
    }

    public Iterator getTrustedCerts() {
        return ((AbstractList)this.trustEngine.getTrustedCerts()).iterator();
    }

    static boolean isEOF(InputStream inputStream) throws IOException {
        inputStream.mark(1);
        if (inputStream.read() < 0) {
            return true;
        }
        inputStream.reset();
        return false;
    }

    static InputStream markableInputStream(InputStream inputStream) throws IOException {
        int n;
        if (inputStream.markSupported()) {
            return inputStream;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public void validateCertPath(X509Certificate[] x509CertificateArray) throws CertificateException, CertPathValidationException {
        try {
            this.trustEngine.verifyCertChain(x509CertificateArray, this.checker);
        }
        catch (CertPathException certPathException) {
            throw new CertPathValidationException(certPathException.toString());
        }
        catch (IOException iOException) {
            throw new CertPathValidationException(iOException.toString());
        }
    }

    static X509CertChecker wrap(final CertChecker certChecker) {
        if (certChecker == null) {
            return null;
        }
        return new X509CertChecker(){

            public void checkCert(X509Certificate x509Certificate, Date date) throws CertificateException {
                certChecker.checkCert(x509Certificate, date);
            }
        };
    }
}

