/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.common.X500Name;
import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.ClientKeyExchanger;
import com.dstc.security.ssl.DHClientKeyExchanger;
import com.dstc.security.ssl.DSASignature;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.RSAClientKeyExchanger;
import com.dstc.security.ssl.RSASignature;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.SSLSession;
import com.dstc.security.ssl.SSLSocket;
import com.dstc.security.ssl.TrustEngine;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;

final class ClientHandShaker
extends HandShaker {
    private X509Certificate[] clientCertPath;
    private PublicKey clientPubKey;
    private PrivateKey clientPrivKey;
    private String sigProvider;
    private int last;
    private byte[] offeredId;
    private ClientKeyExchanger keyX;
    private PublicKey serverSigningKey;
    private boolean clientAuthRequired;

    ClientHandShaker(SSLSocket sSLSocket, SecureRandom secureRandom, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine) throws SSLException {
        this(sSLSocket, secureRandom, privateKey, x509CertificateArray, trustEngine, null);
    }

    ClientHandShaker(SSLSocket sSLSocket, SecureRandom secureRandom, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine, String string) throws SSLException {
        super(true, sSLSocket, secureRandom, trustEngine);
        this.clientCertPath = x509CertificateArray;
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            this.clientPubKey = x509CertificateArray[0].getPublicKey();
        }
        this.clientPrivKey = privateKey;
        this.sigProvider = string;
        this.setEnabledCipherSuites(sSLSocket.getEnabledCipherSuites());
    }

    boolean clientAuthRequired() {
        return this.clientAuthRequired;
    }

    private void finish() throws IOException {
        if (this.sessionReuse) {
            this.out.writeChangeCipherSpec();
            this.changeCipher(0, 1);
            this.sendHandShake((byte)20, this.generateHashes());
        }
        this.handShakeState = 2;
        this.last = 0;
        this.signalHandshakeCompleted();
    }

    private byte[] generateClientSignature(PrivateKey privateKey) throws IOException {
        try {
            Signature signature;
            String string = privateKey.getAlgorithm();
            if (this.sigProvider != null) {
                string = "RSA";
                signature = Signature.getInstance("Raw" + string, this.sigProvider);
            } else {
                signature = Signature.getInstance("Raw" + string);
            }
            signature.initSign(privateKey);
            signature.update(this.ctx.getMac().toBeSignedCV(string, this.shaHash, this.md5Hash, this.masterSecret));
            return signature.sign();
        }
        catch (Exception exception) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)40);
            throw new SSLKeyException(exception.getMessage());
        }
    }

    final void getSessionID() throws IOException {
        SSLSession sSLSession = this.socket.getSessionCache().getFirstValidSession();
        if (!this.socket.getEnableSessionCreation() && sSLSession == null) {
            this.sendAlert((byte)2, (byte)40);
            throw new SSLException("Cannot re-use session: not found in cache");
        }
        if (this.socket.getSessionResumptionForbidden()) {
            sSLSession = null;
        }
        if (sSLSession == null) {
            if (Debug.debug >= 1) {
                com.dstc.security.util.Debug.debug("\nOffering new session");
            }
            this.offeredId = new byte[0];
        } else {
            if (Debug.debug >= 1) {
                com.dstc.security.util.Debug.debug("\nOffering session reuse");
            }
            this.offeredId = sSLSession.getId();
            this.masterSecret = sSLSession.getMasterSecret();
        }
    }

    final void nextMessage(SSLProtocolUnit sSLProtocolUnit) throws IOException {
        int n;
        byte[] byArray = sSLProtocolUnit.getBytes();
        if (sSLProtocolUnit.getContentType() == 22) {
            n = ((HandShake)sSLProtocolUnit).getMessageType();
        } else if (sSLProtocolUnit.getContentType() == 20) {
            n = -1;
        } else {
            throw new SSLException("Bad message");
        }
        switch (n) {
            case 0: {
                this.respondToHelloRequest();
                break;
            }
            case 2: {
                this.updateHashes(byArray);
                this.processServerHello(byArray, 4);
                break;
            }
            case 11: {
                if (this.last != 2) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                this.updateHashes(byArray);
                this.processCertificates(byArray, 4);
                break;
            }
            case 12: {
                if (this.last != 11) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                if (!this.isExportable() && !this.isDiffieHellmanEphKeyX()) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Server key exchange not expected");
                }
                this.updateHashes(byArray);
                this.keyX.setServerKey(byArray, 4);
                break;
            }
            case 13: {
                if (this.last != 12 && this.last != 11) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                this.updateHashes(byArray);
                this.processCertificateRequest(byArray, 4);
                this.clientAuthRequired = true;
                break;
            }
            case 14: {
                if (this.last != 12 && this.last != 11 && this.last != 13) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                this.updateHashes(byArray);
                this.respond();
                break;
            }
            case -1: {
                if (this.last != 14 && this.last != 2) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                this.changeCipher(1, 0);
                break;
            }
            case 20: {
                if (this.last != -1) {
                    this.sendAlert((byte)2, (byte)10);
                    throw new SSLProtocolException("Messages out of order");
                }
                this.checkHashes(byArray, 4);
                this.updateHashes(byArray);
                this.finish();
                return;
            }
        }
        this.last = n;
        this.in.readHandShake();
    }

    private void processAcceptableCAs(byte[] byArray, int n, int n2) throws IOException {
        if (Debug.debug >= 1) {
            com.dstc.security.util.Debug.debug("Acceptable CAs: ");
        }
        try {
            int n3 = n;
            while (n3 < n + n2) {
                int n4 = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n3 += 2, n4);
                X500Name x500Name = new X500Name(byteArrayInputStream);
                n3 += n4;
                if (Debug.debug < 1) continue;
                com.dstc.security.util.Debug.debug(x500Name.getName());
            }
        }
        catch (Asn1Exception asn1Exception) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)40);
            throw new SSLHandshakeException(asn1Exception.getMessage());
        }
    }

    private void processCertificateRequest(byte[] byArray, int n) throws IOException {
        int n2 = byArray[n];
        int n3 = n + 1;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3, byArray2, 0, n2);
        n3 += n2;
        n2 = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
        this.processAcceptableCAs(byArray, n3 += 2, n2);
    }

    private void processCertificates(byte[] byArray, int n) throws IOException {
        int n2 = (byArray[n] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF;
        if (n2 <= 0) {
            this.handShakeState = 3;
            this.sendAlert((byte)2, (byte)42);
            throw new SSLPeerUnverifiedException("Server did not authenticate");
        }
        this.processPeerCertChain(byArray, n + 3, n2);
    }

    void processPeerPublicKey(PublicKey publicKey) throws KeyException {
        String string = publicKey.getAlgorithm();
        if (string.equals("RSA")) {
            this.serverSigningKey = publicKey;
            this.serverSig = new RSASignature();
            this.serverSig.initVerify(publicKey, this.clientHelloRandom, this.serverHelloRandom);
            if (!this.isDiffieHellmanKeyX()) {
                this.keyX.setServerKey(publicKey);
            }
        } else if (string.equals("DSA")) {
            this.serverSigningKey = publicKey;
            this.serverSig = new DSASignature();
            this.serverSig.initVerify(publicKey, this.clientHelloRandom, this.serverHelloRandom);
        } else {
            this.keyX.setServerKey(publicKey);
        }
    }

    private void processServerHello(byte[] byArray, int n) throws IOException {
        this.ctx.setPendingProtocolVersion(byArray, n);
        int n2 = n + 2;
        System.arraycopy(byArray, n2, this.serverHelloRandom, 0, 32);
        byte by = byArray[n2 += 32];
        this.currentId = new byte[by];
        System.arraycopy(byArray, ++n2, this.currentId, 0, by);
        byte[] byArray2 = new byte[]{byArray[n2 += by], byArray[n2 + 1]};
        n2 += 2;
        if (Debug.debug >= 1) {
            com.dstc.security.util.Debug.debug("\nProtocol Version");
            com.dstc.security.util.Debug.debug("version: ", this.ctx.getPendingProtocolVersion());
            com.dstc.security.util.Debug.debug("\nChosen Cipher Suite");
            com.dstc.security.util.Debug.debug(CipherSuites.getSuiteName(byArray2));
            com.dstc.security.util.Debug.debug("");
        }
        int n3 = 0;
        while (true) {
            if (n3 >= this.enabledCipherSuites.length) {
                this.handShakeState = 3;
                this.sendAlert((byte)2, (byte)40);
                throw new SSLHandshakeException("Server tried bad ciphersuite on us!");
            }
            if (this.enabledCipherSuites[n3][0] == byArray2[0] && this.enabledCipherSuites[n3][1] == byArray2[1]) break;
            ++n3;
        }
        this.setPendingCipherSuite(byArray2);
        this.keyX = this.isDiffieHellmanKeyX() ? new DHClientKeyExchanger(this, this.rand, this.clientPrivKey, this.clientPubKey) : new RSAClientKeyExchanger(this, this.rand);
        byte by2 = byArray[n2];
        if (this.offeredId.length > 0) {
            if (Arrays.equals(this.offeredId, this.currentId)) {
                this.sessionReuse = true;
                this.computeKeyBlock();
            } else {
                this.sessionReuse = false;
            }
        } else {
            this.sessionReuse = false;
        }
    }

    private void respond() throws IOException {
        if (this.clientAuthRequired) {
            this.sendCertificates(this.clientCertPath);
        }
        this.sendHandShake((byte)16, this.keyX.getExchangeKeys());
        if (this.clientAuthRequired && HandShaker.keyCanSign(this.clientPrivKey)) {
            this.sendCertificateVerify(this.clientPrivKey);
        }
        this.out.writeChangeCipherSpec();
        if (Debug.debug >= 1) {
            com.dstc.security.util.Debug.debug("Sent ChangeCipherSpec");
        }
        this.computeKeyBlock();
        this.changeCipher(0, 1);
        this.sendHandShake((byte)20, this.generateHashes());
    }

    private void respondToHelloRequest() throws IOException {
        if (this.handShakeStarted()) {
            return;
        }
        this.reset();
        this.handShakeState = 1;
        this.sendClientHello();
    }

    private void sendCertificateVerify(PrivateKey privateKey) throws IOException {
        this.buf.reset();
        byte[] byArray = this.generateClientSignature(privateKey);
        this.buf.write((byte)(byArray.length >> 8 & 0xFF));
        this.buf.write((byte)(byArray.length & 0xFF));
        this.buf.write(byArray);
        this.sendHandShake((byte)15, this.buf.toByteArray());
    }

    private void sendClientHello() throws IOException {
        int n;
        this.buf.reset();
        this.rand.nextBytes(this.clientHelloRandom);
        long l = System.currentTimeMillis();
        this.clientHelloRandom[0] = (byte)(l >> 24 & 0xFFL);
        this.clientHelloRandom[1] = (byte)(l >> 16 & 0xFFL);
        this.clientHelloRandom[2] = (byte)(l >> 8 & 0xFFL);
        this.clientHelloRandom[3] = (byte)(l & 0xFFL);
        this.getSessionID();
        this.ctx.setPendingProtocolVersion(this.protocolVersion, 0);
        this.buf.write(this.protocolVersion);
        this.buf.write(this.clientHelloRandom);
        this.buf.write((byte)(this.offeredId.length & 0xFF));
        this.buf.write(this.offeredId);
        if (this.enabledCipherSuites == null) {
            this.sendAlert((byte)2, (byte)40);
            throw new SSLException("No enabled cipher suites to offer");
        }
        if (Debug.debug >= 1) {
            com.dstc.security.util.Debug.debug("\nOffering Cipher Suites");
            n = 0;
            while (n < this.enabledCipherSuites.length) {
                com.dstc.security.util.Debug.debug(CipherSuites.getSuiteName(this.enabledCipherSuites[n]));
                ++n;
            }
            com.dstc.security.util.Debug.debug("");
        }
        this.buf.write((byte)(2 * this.enabledCipherSuites.length >> 8 & 0xFF));
        this.buf.write((byte)(2 * this.enabledCipherSuites.length & 0xFF));
        n = 0;
        while (n < this.enabledCipherSuites.length) {
            this.buf.write(this.enabledCipherSuites[n]);
            ++n;
        }
        this.buf.write((byte)(this.compressionMethods.length & 0xFF));
        this.buf.write(this.compressionMethods);
        this.sendHandShake((byte)1, this.buf.toByteArray());
    }

    final void setEnabledCipherSuites(String[] stringArray) {
        int n;
        Object object;
        if (stringArray[0].indexOf("TLS") != -1) {
            this.protocolVersion = HandShaker.TLS;
        }
        Object object2 = new byte[stringArray.length][];
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            object = stringArray[n3].substring(4);
            n = 0;
            while (n < CipherSuites.suiteName.length) {
                if (((String)object).equals(CipherSuites.suiteName[n])) {
                    object2[n2++] = CipherSuites.suiteType[n];
                    break;
                }
                ++n;
            }
            ++n3;
        }
        if (n2 < ((byte[][])object2).length) {
            object = new byte[n2][];
            n = 0;
            while (n < n2) {
                object[n] = object2[n];
                ++n;
            }
            object2 = object;
        }
        this.enabledCipherSuites = object2;
    }

    final void startHandShake() throws IOException {
        if (this.handShakeStarted()) {
            return;
        }
        this.reset();
        this.handShakeState = 1;
        this.sendClientHello();
        this.in.readHandShake();
    }
}

