/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.ClientKeyExchanger;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.SSLSignature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

class DHClientKeyExchanger
implements ClientKeyExchanger {
    private final ClientHandShaker handShaker;
    private final SecureRandom rand;
    private final KeyFactory keyFact;
    private final KeyAgreement keyAg;
    private KeyPairGenerator kpg;
    private final DHPrivateKey clientPrivKey;
    private final DHPublicKey clientPubKey;
    private DHPublicKey serverKeyXKey;

    DHClientKeyExchanger(ClientHandShaker clientHandShaker, SecureRandom secureRandom, PrivateKey privateKey, PublicKey publicKey) {
        try {
            this.handShaker = clientHandShaker;
            this.rand = secureRandom;
            this.keyFact = KeyFactory.getInstance("DH");
            this.keyAg = KeyAgreement.getInstance("DH");
            if (!clientHandShaker.isDiffieHellmanEphKeyX() && privateKey instanceof DHPrivateKey && publicKey instanceof DHPublicKey) {
                this.clientPrivKey = (DHPrivateKey)this.keyFact.translateKey(privateKey);
                this.clientPubKey = (DHPublicKey)this.keyFact.translateKey(publicKey);
            } else {
                this.clientPrivKey = null;
                this.clientPubKey = null;
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException.toString());
        }
    }

    public byte[] getExchangeKeys() throws IOException {
        Object object;
        Object object2;
        DHPrivateKey dHPrivateKey = null;
        DHPublicKey dHPublicKey = null;
        byte[] byArray = null;
        try {
            if (this.handShaker.clientAuthRequired() && this.clientPubKey != null && this.clientPrivKey != null) {
                object2 = this.clientPrivKey.getParams();
                if (HandShaker.dhParamsMatch((DHParameterSpec)object2, (DHParameterSpec)(object = this.serverKeyXKey.getParams()))) {
                    dHPrivateKey = this.clientPrivKey;
                    dHPublicKey = this.clientPubKey;
                    byArray = new byte[]{};
                } else {
                    this.kpg = KeyPairGenerator.getInstance("DH");
                }
            } else {
                this.kpg = KeyPairGenerator.getInstance("DH");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException.toString());
        }
        if (this.kpg != null) {
            try {
                this.kpg.initialize(this.serverKeyXKey.getParams(), this.rand);
                object2 = ((KeyPairGeneratorSpi)this.kpg).generateKeyPair();
                dHPrivateKey = (DHPrivateKey)((KeyPair)object2).getPrivate();
                dHPublicKey = (DHPublicKey)((KeyPair)object2).getPublic();
                byArray = dHPublicKey.getY().toByteArray();
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException("Internal error: " + invalidAlgorithmParameterException.getMessage());
            }
        }
        try {
            this.keyAg.init(dHPrivateKey, this.rand);
            this.keyAg.doPhase(this.serverKeyXKey, true);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException("Internal error: " + invalidKeyException.getMessage());
        }
        object2 = this.keyAg.generateSecret();
        this.handShaker.computeMasterSecret((byte[])object2);
        if (Debug.debug >= 3) {
            com.dstc.security.util.Debug.debug("preMasterSecret: ", (byte[])object2);
        }
        if (Debug.debug >= 3) {
            com.dstc.security.util.Debug.debug("exchangeKeys: ", byArray);
        }
        object = new ByteArrayOutputStream();
        int n = byArray.length;
        int n2 = 0;
        if (n > 0) {
            n2 = byArray[0] == 0 ? 1 : 0;
            n -= n2;
        }
        ((ByteArrayOutputStream)object).write((byte)(n >> 8));
        ((ByteArrayOutputStream)object).write((byte)n);
        ((ByteArrayOutputStream)object).write(byArray, n2, n);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public void setServerKey(PublicKey publicKey) {
        this.serverKeyXKey = (DHPublicKey)publicKey;
    }

    public void setServerKey(byte[] byArray, int n) throws IOException {
        int n2 = n;
        int n3 = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2 += 2, byArray2, 0, n3);
        n2 += n3;
        n3 = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2 += 2, byArray3, 0, n3);
        n2 += n3;
        n3 = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, n2 += 2, byArray4, 0, n3);
        n2 += n3;
        SSLSignature sSLSignature = this.handShaker.getServerSignature();
        if (sSLSignature != null) {
            int n4 = n2 - n;
            n3 = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
            byte[] byArray5 = new byte[n3];
            System.arraycopy(byArray, n2 += 2, byArray5, 0, n3);
            try {
                sSLSignature.setData(byArray, n, n4);
                if (!sSLSignature.verify(byArray5)) {
                    throw new IOException("Bad server signature");
                }
            }
            catch (SignatureException signatureException) {
                throw new IOException(signatureException.getMessage());
            }
        }
        try {
            this.serverKeyXKey = (DHPublicKey)this.keyFact.generatePublic(new DHPublicKeySpec(new BigInteger(1, byArray4), new BigInteger(1, byArray2), new BigInteger(1, byArray3)));
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.getMessage());
        }
    }
}

