/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.SSLSignature;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.ServerKeyExchanger;
import com.dstc.security.util.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.SSLException;

class DHServerKeyExchanger
implements ServerKeyExchanger {
    private final ServerHandShaker handShaker;
    private final SecureRandom rand;
    private final KeyFactory keyFact;
    private final KeyAgreement keyAg;
    private final KeyPairGenerator kpg;
    private final DHPublicKey serverPubKey;
    private DHPrivateKey serverKeyXKey;

    DHServerKeyExchanger(ServerHandShaker serverHandShaker, SecureRandom secureRandom, PrivateKey privateKey, PublicKey publicKey) {
        try {
            this.handShaker = serverHandShaker;
            this.rand = secureRandom;
            this.keyFact = KeyFactory.getInstance("DH");
            this.keyAg = KeyAgreement.getInstance("DH");
            if (!serverHandShaker.isDiffieHellmanEphKeyX()) {
                this.kpg = null;
                this.serverPubKey = (DHPublicKey)this.keyFact.translateKey(publicKey);
                this.serverKeyXKey = (DHPrivateKey)this.keyFact.translateKey(privateKey);
            } else {
                this.kpg = KeyPairGenerator.getInstance("DH");
                this.serverPubKey = null;
                this.serverKeyXKey = null;
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException.toString());
        }
    }

    private KeyPair generateTempDHPubKey(int n) throws IOException {
        try {
            this.kpg.initialize(n, this.rand);
            return ((KeyPairGeneratorSpi)this.kpg).generateKeyPair();
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.getMessage());
        }
    }

    public byte[] getPreMasterSecret(byte[] byArray, int n, PublicKey publicKey) throws IOException {
        try {
            PublicKey publicKey2 = this.staticDH(publicKey);
            this.keyAg.init((Key)this.serverKeyXKey, this.rand);
            int n2 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
            if (publicKey2 == null) {
                if (n2 == 0) {
                    throw new SSLException("Client sent neither a compatible DH cert nor temporary pub key");
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n + 2, byArray2, 0, n2);
                DHParameterSpec dHParameterSpec = this.serverKeyXKey.getParams();
                publicKey2 = this.keyFact.generatePublic(new DHPublicKeySpec(new BigInteger(1, byArray2), dHParameterSpec.getP(), dHParameterSpec.getG()));
            } else {
                if (n2 != 0) {
                    throw new SSLException("Client sent compatible DH cert and temporary pub key");
                }
                this.handShaker.setClientAuthenticated();
            }
            this.keyAg.doPhase(publicKey2, true);
            return this.keyAg.generateSecret();
        }
        catch (Exception exception) {
            throw new SSLException(exception.getMessage());
        }
    }

    public byte[] getServerKey(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        KeyPair keyPair = this.generateTempDHPubKey(n);
        this.serverKeyXKey = (DHPrivateKey)keyPair.getPrivate();
        DHPublicKey dHPublicKey = (DHPublicKey)keyPair.getPublic();
        DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
        byte[] byArray = Bytes.removeLeadingZero(dHParameterSpec.getP().toByteArray());
        byte[] byArray2 = Bytes.removeLeadingZero(dHParameterSpec.getG().toByteArray());
        byte[] byArray3 = Bytes.removeLeadingZero(dHPublicKey.getY().toByteArray());
        byteArrayOutputStream.write((byte)(byArray.length >> 8));
        byteArrayOutputStream.write((byte)byArray.length);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write((byte)(byArray2.length >> 8));
        byteArrayOutputStream.write((byte)byArray2.length);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write((byte)(byArray3.length >> 8));
        byteArrayOutputStream.write((byte)byArray3.length);
        byteArrayOutputStream.write(byArray3);
        SSLSignature sSLSignature = this.handShaker.getServerSignature();
        if (sSLSignature != null) {
            byte[] byArray4 = byteArrayOutputStream.toByteArray();
            try {
                sSLSignature.setData(byArray4, 0, byArray4.length);
                byte[] byArray5 = sSLSignature.sign();
                byteArrayOutputStream.write((byte)(byArray5.length >> 8 & 0xFF));
                byteArrayOutputStream.write((byte)(byArray5.length & 0xFF));
                byteArrayOutputStream.write(byArray5);
            }
            catch (SignatureException signatureException) {
                throw new RuntimeException("Internal error: " + signatureException.getMessage());
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private DHPublicKey staticDH(PublicKey publicKey) {
        DHParameterSpec dHParameterSpec;
        if (this.serverPubKey == null || !(publicKey instanceof DHPublicKey)) {
            return null;
        }
        DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
        DHParameterSpec dHParameterSpec2 = dHPublicKey.getParams();
        return HandShaker.dhParamsMatch(dHParameterSpec2, dHParameterSpec = this.serverPubKey.getParams()) ? dHPublicKey : null;
    }
}

