/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.V3Message;
import java.io.IOException;

class HandShake
extends V3Message {
    static final byte HELLO_REQUEST = 0;
    static final byte CLIENT_HELLO = 1;
    static final byte SERVER_HELLO = 2;
    static final byte CERTIFICATE = 11;
    static final byte SERVER_KEY_EXCHANGE = 12;
    static final byte CERTIFICATE_REQUEST = 13;
    static final byte SERVER_HELLO_DONE = 14;
    static final byte CERTIFICATE_VERIFY = 15;
    static final byte CLIENT_KEY_EXCHANGE = 16;
    static final byte FINISHED = 20;
    private byte msgType;
    private int bodyLength;

    HandShake() {
        this.contentType = (byte)22;
    }

    HandShake(byte by, byte[] byArray) {
        this();
        this.msgType = by;
        if (byArray != null) {
            this.bodyLength = byArray.length;
        }
        this.data = new byte[this.bodyLength + 4];
        this.data[0] = by;
        this.data[1] = (byte)(this.bodyLength >> 16 & 0xFF);
        this.data[2] = (byte)(this.bodyLength >> 8 & 0xFF);
        this.data[3] = (byte)(this.bodyLength & 0xFF);
        if (byArray != null) {
            System.arraycopy(byArray, 0, this.data, 4, this.bodyLength);
        }
    }

    int getLength() {
        return this.bodyLength + 4;
    }

    byte getMessageType() {
        return this.msgType;
    }

    void refresh(byte[] byArray, int n, int n2) throws IOException {
        this.data = new byte[n2];
        System.arraycopy(byArray, n, this.data, 0, n2);
        this.msgType = byArray[n];
        this.bodyLength = (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }
}

