/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Alert;
import com.dstc.security.ssl.ApplicationData;
import com.dstc.security.ssl.ChangeCipherSpec;
import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.SSLContext;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.V2ClientHello;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;

final class ProtocolUnitInputStream
extends FilterInputStream {
    private SSLContext ctx;
    private byte[] buffer;
    private int bufOff;
    private int bufLen;
    private byte[] dataBuffer = new byte[0];
    private int dataBufOff;
    private int dataBufLen;
    private byte[] cipherTextBuf = new byte[0];
    private int type;
    private byte[] version = new byte[2];
    private boolean eof = false;
    private ApplicationData appData = new ApplicationData();
    private Alert alert = new Alert();
    private ChangeCipherSpec changeCipherSpec = new ChangeCipherSpec();
    private HandShake handShake = new HandShake();
    private Object readLock;
    private byte[] readBuffer = new byte[1];
    private boolean inClosed = false;

    ProtocolUnitInputStream(SSLContext sSLContext, InputStream inputStream, Object object) {
        super(inputStream);
        this.readLock = object;
        this.ctx = sSLContext;
    }

    public int available() throws IOException {
        if (!this.ctx.getHandShaker().handShakeCompleted()) {
            Thread.yield();
            return 0;
        }
        if (this.dataBufLen > 0) {
            return this.dataBufLen;
        }
        return this.in.available();
    }

    private boolean bufferEmpty() {
        return this.bufLen == 0;
    }

    public void close() throws IOException {
        this.in.close();
        this.inClosed = true;
    }

    public int read() throws IOException {
        int n = this.read(this.readBuffer);
        if (n == -1) {
            return n;
        }
        return this.readBuffer[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.ctx.getHandShaker().handShakeNotYetBegun() && this.ctx.getHandShaker() instanceof ClientHandShaker) {
            this.ctx.getHandShaker().startHandShake();
        }
        Object object = this.readLock;
        synchronized (object) {
            try {
                while (!this.ctx.getHandShaker().handShakeCompleted()) {
                    this.readLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.readApplicationData(byArray, n, n2);
    }

    int readApplicationData(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (n2 <= this.dataBufLen) {
            System.arraycopy(this.dataBuffer, this.dataBufOff, byArray, n, n2);
            this.dataBufLen -= n2;
            this.dataBufOff = this.dataBufLen == 0 ? 0 : this.dataBufOff + n2;
            return n2;
        }
        int n3 = 0;
        if (this.dataBufLen > 0) {
            System.arraycopy(this.dataBuffer, this.dataBufOff, byArray, n, this.dataBufLen);
            this.dataBufOff = 0;
            this.dataBufLen = 0;
            return n3 += this.dataBufLen;
        }
        SSLProtocolUnit sSLProtocolUnit = this.readProtocolUnit();
        if (sSLProtocolUnit instanceof ApplicationData) {
            this.dataBufLen = ((ApplicationData)sSLProtocolUnit).getLength();
            if (this.dataBuffer.length < this.dataBufLen) {
                this.dataBuffer = new byte[this.dataBufLen];
            }
            ((ApplicationData)sSLProtocolUnit).copy(this.dataBuffer, this.dataBufOff);
            if (Debug.debug >= 2) {
                com.dstc.security.util.Debug.debug("read data: " + this.dataBuffer.length + " bytes");
            }
            return this.readApplicationData(byArray, n + n3, n2 - n3);
        }
        if (sSLProtocolUnit instanceof HandShake) {
            if (Debug.debug >= 2) {
                com.dstc.security.util.Debug.debug("handshake in data");
            }
            this.ctx.getHandShaker().nextMessage(sSLProtocolUnit);
            return n3;
        }
        if (sSLProtocolUnit instanceof ChangeCipherSpec) {
            if (Debug.debug >= 2) {
                com.dstc.security.util.Debug.debug("change cipher spec in data");
            }
            this.ctx.getHandShaker().nextMessage(sSLProtocolUnit);
            return n3;
        }
        if (sSLProtocolUnit instanceof Alert) {
            if (Debug.debug >= 1) {
                System.out.println("++Alert in Data");
            }
            if (((Alert)sSLProtocolUnit).isFatal()) {
                try {
                    this.ctx.getHandShaker().sendAlert((byte)2, (byte)40);
                }
                catch (Exception exception) {}
                throw new SSLHandshakeException(sSLProtocolUnit.toString());
            }
            if (((Alert)sSLProtocolUnit).getDescription() == 0) {
                this.in.close();
                this.inClosed = true;
            }
            return n3;
        }
        if (sSLProtocolUnit == null) {
            return n3;
        }
        throw new RuntimeException("Internal error");
    }

    void readHandShake() throws IOException {
        do {
            SSLProtocolUnit sSLProtocolUnit;
            if ((sSLProtocolUnit = this.readProtocolUnit()) == null) {
                throw new IOException("Eof encountered");
            }
            if (sSLProtocolUnit instanceof Alert) {
                if (Debug.debug >= 1) {
                    System.out.println(sSLProtocolUnit);
                }
                if (((Alert)sSLProtocolUnit).isFatal()) {
                    try {
                        this.ctx.getHandShaker().sendAlert((byte)2, (byte)40);
                    }
                    catch (Exception exception) {}
                    throw new SSLHandshakeException(sSLProtocolUnit.toString());
                }
                if (((Alert)sSLProtocolUnit).getDescription() == 0) {
                    this.in.close();
                    this.inClosed = true;
                }
                this.readHandShake();
                continue;
            }
            if (sSLProtocolUnit instanceof ApplicationData) {
                int n = ((ApplicationData)sSLProtocolUnit).getLength();
                byte[] byArray = new byte[n + this.dataBufLen];
                System.arraycopy(this.dataBuffer, this.dataBufOff, byArray, 0, this.dataBufLen);
                ((ApplicationData)sSLProtocolUnit).copy(byArray, this.dataBufLen);
                this.dataBuffer = byArray;
                this.dataBufOff = 0;
                this.dataBufLen = this.dataBuffer.length;
                this.readHandShake();
                continue;
            }
            this.ctx.getHandShaker().nextMessage(sSLProtocolUnit);
        } while (!this.bufferEmpty());
    }

    private SSLProtocolUnit readProtocolUnit() throws IOException {
        int n;
        if (this.bufferEmpty()) {
            if (this.inClosed) {
                this.eof = true;
                return null;
            }
            this.type = this.in.read();
            if (this.type == -1) {
                this.eof = true;
                return null;
            }
            if (Debug.debug >= 2) {
                com.dstc.security.util.Debug.debug("Type: " + this.type);
            }
            if ((this.type & 0x80) == 128) {
                int n2 = this.in.read();
                if (n2 == -1) {
                    this.eof = true;
                    return null;
                }
                int n3 = (this.type & 0x7F) >> 8 | n2 & 0xFF;
                if (this.cipherTextBuf.length < n3) {
                    this.cipherTextBuf = new byte[n3];
                }
                int n4 = 0;
                while (n4 < n3) {
                    n4 += this.in.read(this.cipherTextBuf, n4, n3 - n4);
                }
                return new V2ClientHello(this.cipherTextBuf, 0, n3);
            }
            int n5 = this.in.read();
            if (n5 == -1) {
                this.eof = true;
                return null;
            }
            this.version[0] = (byte)n5;
            n5 = this.in.read();
            if (n5 == -1) {
                this.eof = true;
                return null;
            }
            this.version[1] = (byte)n5;
            if (Debug.debug >= 2) {
                com.dstc.security.util.Debug.debug("Major, minor: " + this.version[0] + ", " + this.version[1]);
            }
            if ((n5 = this.in.read()) == -1) {
                this.eof = true;
                return null;
            }
            int n6 = n5 << 8;
            n5 = this.in.read();
            if (n5 == -1) {
                this.eof = true;
                return null;
            }
            n6 |= n5;
            if (Debug.debug >= 2) {
                com.dstc.security.util.Debug.debug("Record length: " + n6);
            }
            if (this.cipherTextBuf.length < n6) {
                this.cipherTextBuf = new byte[n6];
            }
            n = 0;
            while (n < n6) {
                n += this.in.read(this.cipherTextBuf, n, n6 - n);
            }
            try {
                this.buffer = new byte[n6];
                this.bufLen = this.ctx.doDecrypt((byte)this.type, this.cipherTextBuf, 0, n6, this.buffer);
            }
            catch (ShortBufferException shortBufferException) {
                throw new RuntimeException("Internal error: " + shortBufferException.getMessage());
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                this.ctx.getHandShaker().sendAlert((byte)2, (byte)40);
                throw new SSLException("Decryption failure");
            }
            catch (SSLProtocolException sSLProtocolException) {
                this.ctx.getHandShaker().sendAlert((byte)2, (byte)20);
                throw sSLProtocolException;
            }
            this.bufOff = 0;
        }
        Object var2_5 = null;
        switch (this.type) {
            case 20: {
                this.changeCipherSpec.refresh(this.buffer, this.bufOff, this.bufLen);
                this.bufOff += this.bufLen;
                this.bufLen -= this.bufOff;
                return this.changeCipherSpec;
            }
            case 21: {
                this.alert.refresh(this.buffer, this.bufOff, this.bufLen);
                this.bufOff += this.bufLen;
                this.bufLen -= this.bufOff;
                return this.alert;
            }
            case 23: {
                this.appData.refresh(this.buffer, this.bufOff, this.bufLen);
                this.bufOff += this.bufLen;
                this.bufLen -= this.bufOff;
                return this.appData;
            }
            case 22: {
                n = (this.buffer[this.bufOff + 1] & 0xFF) << 16 | (this.buffer[this.bufOff + 2] & 0xFF) << 8 | this.buffer[this.bufOff + 3] & 0xFF;
                this.handShake.refresh(this.buffer, this.bufOff, 4 + n);
                this.bufOff += 4 + n;
                this.bufLen -= 4 + n;
                if (Debug.debug >= 2) {
                    com.dstc.security.util.Debug.debug("HandShake type: " + this.handShake.getMessageType());
                    com.dstc.security.util.Debug.debug("Content length: " + (4 + n));
                }
                return this.handShake;
            }
        }
        this.ctx.getHandShaker().sendAlert((byte)2, (byte)40);
        throw new SSLProtocolException("Bad ContentType received");
    }
}

