/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.SSLContext;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.ShortBufferException;
import javax.net.ssl.SSLHandshakeException;

final class ProtocolUnitOutputStream
extends FilterOutputStream {
    private static final int INITIAL_BUF_SIZE = 128;
    private static final byte[] CSS_DATA = new byte[]{1};
    private SSLContext ctx;
    private byte[] buffer;
    private byte[] alert = new byte[2];
    private static final int MAX_FRAGMENT_SIZE = 16000;
    private Object writeLock;
    private byte[] buf = new byte[1];

    ProtocolUnitOutputStream(SSLContext sSLContext, OutputStream outputStream, Object object) {
        super(outputStream);
        this.ctx = sSLContext;
        this.buffer = new byte[128];
        this.writeLock = object;
    }

    public void close() throws IOException {
        try {
            this.ctx.getHandShaker().sendAlert((byte)1, (byte)0);
        }
        catch (Exception exception) {}
        this.out.close();
    }

    private void write(byte by, byte[] byArray, int n, int n2) throws IOException {
        this.out.write(by);
        this.out.write(this.ctx.getPendingProtocolVersion());
        if (this.buffer.length < n2 + 36) {
            this.buffer = new byte[n2 + 36];
        }
        int n3 = 0;
        try {
            n3 = this.ctx.doEncrypt(by, byArray, n, n2, this.buffer);
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("Internal error: " + shortBufferException.getMessage());
        }
        this.out.write((byte)(n3 >> 8 & 0xFF));
        this.out.write((byte)(n3 & 0xFF));
        this.out.write(this.buffer, 0, n3);
        this.out.flush();
    }

    public void write(int n) throws IOException {
        this.buf[0] = (byte)(n & 0xFF);
        this.write(this.buf);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object;
        if (this.ctx.getHandShaker().handShakeNotYetBegun()) {
            object = this.writeLock;
            synchronized (object) {
                if (this.ctx.getHandShaker() instanceof ClientHandShaker) {
                    this.ctx.getHandShaker().startHandShake();
                }
                this.writeLock.notifyAll();
            }
        }
        object = this.writeLock;
        synchronized (object) {
            int n3;
            try {
                while (!this.ctx.getHandShaker().handShakeCompleted()) {
                    this.writeLock.wait();
                }
                if (this.ctx.getHandShaker().badCompletion()) {
                    throw new SSLHandshakeException("Handshake failure");
                }
            }
            catch (InterruptedException interruptedException) {}
            do {
                n3 = n2 > 16000 ? 16000 : n2;
                this.writeApplicationData(byArray, n, n3);
                n += n3;
            } while ((n2 -= n3) != 0);
        }
    }

    void writeAlert(byte by, byte by2) throws IOException {
        this.alert[0] = by;
        this.alert[1] = by2;
        this.write((byte)21, this.alert, 0, 2);
        if (Debug.debug >= 2) {
            com.dstc.security.util.Debug.debug("Sending alert");
        }
    }

    void writeApplicationData(byte[] byArray, int n, int n2) throws IOException {
        this.write((byte)23, byArray, n, n2);
        if (Debug.debug >= 2) {
            com.dstc.security.util.Debug.debug("Sending application data");
        }
    }

    void writeChangeCipherSpec() throws IOException {
        this.write((byte)20, CSS_DATA, 0, 1);
    }

    void writeHandShake(HandShake handShake) throws IOException {
        byte[] byArray = handShake.getBytes();
        this.write((byte)22, byArray, 0, byArray.length);
        if (Debug.debug >= 2) {
            com.dstc.security.util.Debug.debug("Sending handShake: msgType = " + handShake.getMessageType());
        }
    }
}

