/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.SSLServerSocketFactory;
import com.dstc.security.ssl.SSLSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

final class SSLServerSocket
extends javax.net.ssl.SSLServerSocket {
    private SSLServerSocketFactory sockFact = null;
    private String[] enabledCipherSuites = null;
    private boolean useClientMode = false;
    private boolean clientAuthRequired = false;
    private boolean enableSessionCreation = true;

    protected SSLServerSocket(int n) throws IOException {
        super(n);
    }

    protected SSLServerSocket(int n, int n2) throws IOException {
        super(n, n2);
    }

    protected SSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
    }

    public Socket accept() throws IOException {
        SSLSocket sSLSocket = new SSLSocket();
        this.implAccept(sSLSocket);
        if (Debug.debug >= 1) {
            com.dstc.security.util.Debug.debug("Client Auth required: " + this.clientAuthRequired);
        }
        sSLSocket.setSessionResumptionForbidden(this.sockFact.getSessionResumptionForbidden());
        sSLSocket.setEnableSessionCreation(this.enableSessionCreation);
        sSLSocket.init(this.sockFact.getRandom(), this.useClientMode, this.sockFact.getServerPrivateKey(), this.sockFact.getServerCertificates(), this.sockFact.getTrustEngine(), this.enabledCipherSuites, this.clientAuthRequired, this.sockFact.getSessionCache(), null);
        return sSLSocket;
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public boolean getNeedClientAuth() {
        return this.clientAuthRequired;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuites.suiteName;
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    public void init(SSLServerSocketFactory sSLServerSocketFactory) {
        this.sockFact = sSLServerSocketFactory;
        this.enabledCipherSuites = sSLServerSocketFactory.getEnabledCipherSuites();
        this.clientAuthRequired = sSLServerSocketFactory.getClientAuthRequired();
    }

    public void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray;
    }

    public void setNeedClientAuth(boolean bl) {
        this.clientAuthRequired = bl;
    }

    public void setUseClientMode(boolean bl) {
        this.useClientMode = bl;
    }
}

