/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.SSLSocket;
import com.dstc.security.ssl.SessionCache;
import java.net.InetAddress;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;

final class SSLSession
implements javax.net.ssl.SSLSession {
    private final SessionCache cache;
    private final byte[] id;
    private final byte[] suite;
    private final byte[] version;
    private final X509Certificate[] peerCertChain;
    private final InetAddress peerHost;
    private final long creationTime;
    private long lastAccessTime;
    private byte[] masterSecret;
    private boolean isValid = true;

    SSLSession(SSLSocket sSLSocket, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, X509Certificate[] x509CertificateArray) {
        this.cache = sSLSocket.getSessionCache();
        this.id = byArray;
        this.masterSecret = byArray2;
        this.suite = byArray3;
        this.version = byArray4;
        this.lastAccessTime = this.creationTime = System.currentTimeMillis();
        this.peerCertChain = x509CertificateArray;
        this.peerHost = sSLSocket.getInetAddress();
        sSLSocket.setSession(this);
    }

    void addToCache() {
        this.cache.addSession(this);
    }

    public String getCipherSuite() {
        return CipherSuites.getSuiteName(this.suite);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessTime;
    }

    byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public javax.security.cert.X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.peerCertChain == null) {
            throw new SSLPeerUnverifiedException("No certs for peer");
        }
        try {
            javax.security.cert.X509Certificate[] x509CertificateArray = new javax.security.cert.X509Certificate[this.peerCertChain.length];
            int n = 0;
            while (n < this.peerCertChain.length) {
                x509CertificateArray[n] = javax.security.cert.X509Certificate.getInstance(this.peerCertChain[n].getEncoded());
                ++n;
            }
            return x509CertificateArray;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new RuntimeException("Internal error: " + certificateEncodingException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Internal error: " + certificateException.getMessage());
        }
    }

    public String getPeerHost() {
        return this.peerHost.getHostName();
    }

    public SSLSessionContext getSessionContext() {
        return this.cache;
    }

    byte[] getSuite() {
        return this.suite;
    }

    public Object getValue(String string) {
        return null;
    }

    public String[] getValueNames() {
        return null;
    }

    public void invalidate() {
        if (Debug.debug >= 1) {
            System.out.println("Session invalidated");
        }
        this.masterSecret = null;
        this.isValid = false;
    }

    boolean isValid() {
        if (System.currentTimeMillis() - this.getCreationTime() > (long)this.cache.getLifetime()) {
            this.invalidate();
        }
        return this.isValid;
    }

    public void putValue(String string, Object object) {
    }

    public void removeValue(String string) {
    }

    private void toHex(StringBuffer stringBuffer, byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Integer.toHexString(0xFF & byArray[n]));
            ++n;
        }
        stringBuffer.append("\n");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SSL Session\n");
        stringBuffer.append("  id: ");
        this.toHex(stringBuffer, this.id);
        stringBuffer.append("  cipher suite:  ").append(this.getCipherSuite()).append("\n");
        stringBuffer.append("  peer host:     ").append(this.getPeerHost()).append("\n");
        stringBuffer.append("  created:       ");
        stringBuffer.append(new Date(this.creationTime).toString()).append("\n");
        stringBuffer.append("  last accessed: ");
        stringBuffer.append(new Date(this.lastAccessTime).toString()).append("\n");
        return stringBuffer.toString();
    }

    void updateAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }
}

