/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.ProtocolUnitInputStream;
import com.dstc.security.ssl.ProtocolUnitOutputStream;
import com.dstc.security.ssl.SSLContext;
import com.dstc.security.ssl.SSLSocketFactory;
import com.dstc.security.ssl.SessionCache;
import com.dstc.security.ssl.TrustEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;

class SSLSocket
extends javax.net.ssl.SSLSocket {
    protected SSLContext ctx = null;
    private SSLSession session = null;
    private HandShaker handShaker = null;
    private String[] enabledCipherSuites = null;
    private boolean useClientMode = true;
    private boolean clientAuthRequired = false;
    private boolean sessionCreationEnabled = true;
    private boolean sessionResumptionForbidden = false;
    private SessionCache sessionCache = null;
    private Object lock = new Object();
    private ProtocolUnitOutputStream out = null;
    private ProtocolUnitInputStream in = null;
    private SSLSocketFactory sockFact = null;

    protected SSLSocket() throws IOException {
    }

    protected SSLSocket(String string, int n) throws UnknownHostException, IOException {
        super(string, n);
    }

    protected SSLSocket(String string, int n, InetAddress inetAddress, int n2) throws UnknownHostException, IOException {
        super(string, n, inetAddress, n2);
    }

    protected SSLSocket(InetAddress inetAddress, int n) throws UnknownHostException, IOException {
        super(inetAddress, n);
    }

    protected SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws UnknownHostException, IOException {
        super(inetAddress, n, inetAddress2, n2);
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.handShaker.addHandshakeCompletedListener(handshakeCompletedListener);
    }

    public void close() throws IOException {
        try {
            Object object = this.lock;
            synchronized (object) {
                while (!this.handShaker.handShakeCompleted()) {
                    this.lock.notifyAll();
                    this.lock.wait();
                }
                this.lock.notifyAll();
                this.out.flush();
                try {
                    this.handShaker.sendAlert((byte)1, (byte)0);
                }
                catch (Exception exception) {}
            }
            super.close();
        }
        catch (InterruptedException interruptedException) {}
    }

    SSLContext getContext() {
        return this.ctx;
    }

    public boolean getEnableSessionCreation() {
        return this.sessionCreationEnabled;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    Object getHandShakeLock() {
        return this.lock;
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public boolean getNeedClientAuth() {
        return this.clientAuthRequired;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public SSLSession getSession() {
        return this.session;
    }

    SessionCache getSessionCache() {
        return this.sessionCache;
    }

    boolean getSessionResumptionForbidden() {
        return this.sessionResumptionForbidden;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuites.suiteName;
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    void init(SSLSocketFactory sSLSocketFactory) throws UnknownHostException, IOException {
        this.init(sSLSocketFactory, super.getInputStream(), super.getOutputStream());
    }

    void init(SSLSocketFactory sSLSocketFactory, InputStream inputStream, OutputStream outputStream) throws UnknownHostException, IOException {
        this.sockFact = sSLSocketFactory;
        this.init(this.sockFact.getRandom(), true, this.sockFact.getClientPrivateKey(), this.sockFact.getClientCertificates(), this.sockFact.getTrustEngine(), this.sockFact.getEnabledCipherSuites(), false, this.sockFact.getSessionCache(), this.sockFact.getSigProvider(), inputStream, outputStream);
        this.setSessionResumptionForbidden(sSLSocketFactory.getSessionResumptionForbidden());
    }

    void init(SecureRandom secureRandom, boolean bl, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine, String[] stringArray, boolean bl2, SessionCache sessionCache, String string) throws UnknownHostException, IOException {
        this.init(secureRandom, bl, privateKey, x509CertificateArray, trustEngine, stringArray, bl2, sessionCache, string, super.getInputStream(), super.getOutputStream());
    }

    void init(SecureRandom secureRandom, boolean bl, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine, String[] stringArray, boolean bl2, SessionCache sessionCache, String string, InputStream inputStream, OutputStream outputStream) throws UnknownHostException, IOException {
        this.ctx = new SSLContext();
        this.sessionCache = sessionCache;
        this.setEnabledCipherSuites(stringArray);
        this.setNeedClientAuth(bl2);
        this.in = new ProtocolUnitInputStream(this.ctx, inputStream, this.lock);
        this.out = new ProtocolUnitOutputStream(this.ctx, outputStream, this.lock);
        this.handShaker = HandShaker.getInstance(bl, this, secureRandom, privateKey, x509CertificateArray, trustEngine);
        this.ctx.setHandShaker(this.handShaker);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
    }

    public void setEnableSessionCreation(boolean bl) {
        this.sessionCreationEnabled = bl;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray;
        if (this.handShaker != null) {
            this.handShaker.setEnabledCipherSuites(stringArray);
        }
    }

    public void setNeedClientAuth(boolean bl) {
        this.clientAuthRequired = bl;
    }

    void setSession(SSLSession sSLSession) {
        this.session = sSLSession;
    }

    void setSessionResumptionForbidden(boolean bl) {
        this.sessionResumptionForbidden = bl;
    }

    public void setUseClientMode(boolean bl) {
        this.useClientMode = bl;
        try {
            this.handShaker = HandShaker.getInstance(this.useClientMode, this, this.sockFact.getRandom(), this.sockFact.getClientPrivateKey(), this.sockFact.getClientCertificates(), this.sockFact.getTrustEngine());
            this.ctx.setHandShaker(this.handShaker);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal error: " + iOException.getMessage());
        }
    }

    public void startHandshake() throws IOException {
        this.handShaker.startHandShake();
    }
}

