/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.BasicTrustEngine;
import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.LayeredSSLSocket;
import com.dstc.security.ssl.SSLSocket;
import com.dstc.security.ssl.SessionCache;
import com.dstc.security.ssl.TrustEngine;
import com.dstc.security.util.Dependencies;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class SSLSocketFactory
extends javax.net.ssl.SSLSocketFactory {
    private final SecureRandom rand;
    private final TrustEngine trustEngine;
    private final SessionCache cache;
    private final PrivateKey privKey;
    private final X509Certificate[] clientCerts;
    private String[] enabledCipherSuites = null;
    private boolean sessionResumptionForbidden = false;
    private String sigProvider = null;
    private static final String[] DEFAULT_SUITES = new String[]{"SSL_RSA_WITH_IDEA_CBC_SHA", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"};
    static /* synthetic */ Class class$com$dstc$security$ssl$SSLSocketFactory;

    static {
        Dependencies.check(class$com$dstc$security$ssl$SSLSocketFactory != null ? class$com$dstc$security$ssl$SSLSocketFactory : (class$com$dstc$security$ssl$SSLSocketFactory = SSLSocketFactory.class$("com.dstc.security.ssl.SSLSocketFactory")));
    }

    public SSLSocketFactory() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this(null, null, null, BasicTrustEngine.getDefault(), null);
    }

    private SSLSocketFactory(SecureRandom secureRandom, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine, String[] stringArray) {
        this.rand = secureRandom == null ? new SecureRandom() : secureRandom;
        this.rand.nextInt();
        this.trustEngine = trustEngine;
        this.cache = new SessionCache();
        this.privKey = privateKey;
        this.clientCerts = x509CertificateArray;
        this.setDefaultCipherSuites(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = new SSLSocket(string, n);
        sSLSocket.init(this);
        return sSLSocket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        SSLSocket sSLSocket = new SSLSocket(string, n, inetAddress, n2);
        sSLSocket.init(this);
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = new SSLSocket(inetAddress, n);
        sSLSocket.init(this);
        return sSLSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = new SSLSocket(inetAddress, n, inetAddress2, n2);
        sSLSocket.init(this);
        return sSLSocket;
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        LayeredSSLSocket layeredSSLSocket = new LayeredSSLSocket(socket, string, n, bl);
        layeredSSLSocket.init(this, socket.getInputStream(), socket.getOutputStream());
        return layeredSSLSocket;
    }

    X509Certificate[] getClientCertificates() {
        return this.clientCerts;
    }

    PrivateKey getClientPrivateKey() {
        return this.privKey;
    }

    public String[] getDefaultCipherSuites() {
        return this.enabledCipherSuites;
    }

    String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public static SSLSocketFactory getInstance(SecureRandom secureRandom, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine, String[] stringArray) {
        return new SSLSocketFactory(secureRandom, privateKey, x509CertificateArray, trustEngine, stringArray);
    }

    public static SSLSocketFactory getInstance(SecureRandom secureRandom, PrivateKey privateKey, X509Certificate[] x509CertificateArray, TrustEngine trustEngine, String[] stringArray, int n, int n2) {
        SSLSocketFactory sSLSocketFactory = new SSLSocketFactory(secureRandom, privateKey, x509CertificateArray, trustEngine, stringArray);
        sSLSocketFactory.cache.setCacheLimit(n);
        sSLSocketFactory.cache.setLifetime(n2);
        return sSLSocketFactory;
    }

    SecureRandom getRandom() {
        return this.rand;
    }

    SessionCache getSessionCache() {
        return this.cache;
    }

    boolean getSessionResumptionForbidden() {
        return this.sessionResumptionForbidden;
    }

    String getSigProvider() {
        return this.sigProvider;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuites.suiteName;
    }

    TrustEngine getTrustEngine() {
        return this.trustEngine;
    }

    public void setDebugLevel(int n) {
        Debug.debug = n;
    }

    void setDefaultCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray == null ? DEFAULT_SUITES : stringArray;
    }

    public void setSessionResumptionForbidden(boolean bl) {
        this.sessionResumptionForbidden = bl;
    }

    void setSigProvider(String string) {
        this.sigProvider = string;
    }
}

