/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.SSLSession;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLSessionContext;

final class SessionCache
implements SSLSessionContext {
    static int DEFAULT_LIFETIME = 300000;
    static int DEFAULT_CACHELIMIT = 10;
    private int lifetime = DEFAULT_LIFETIME;
    private int cacheLimit = DEFAULT_CACHELIMIT;
    private Hashtable tab = new Hashtable();

    SessionCache() {
    }

    void addSession(SSLSession sSLSession) {
        if (this.tab.size() == this.cacheLimit) {
            SessionId sessionId = this.getFirstRemovableSessionId();
            this.tab.remove(sessionId);
        }
        this.tab.put(new SessionId(sSLSession.getId()), sSLSession);
    }

    void clear() {
        this.tab.clear();
    }

    int getCacheLimit() {
        return this.cacheLimit;
    }

    SessionId getFirstRemovableSessionId() {
        SessionId sessionId = null;
        Enumeration enumeration = this.tab.keys();
        while (enumeration.hasMoreElements()) {
            sessionId = (SessionId)enumeration.nextElement();
            if (((SSLSession)this.tab.get(sessionId)).isValid()) continue;
            return sessionId;
        }
        enumeration = this.tab.keys();
        sessionId = (SessionId)enumeration.nextElement();
        return sessionId;
    }

    SSLSession getFirstValidSession() {
        Enumeration enumeration = this.tab.keys();
        while (enumeration.hasMoreElements()) {
            SSLSession sSLSession = (SSLSession)this.tab.get((SessionId)enumeration.nextElement());
            if (!sSLSession.isValid()) continue;
            return sSLSession;
        }
        return null;
    }

    public Enumeration getIds() {
        Vector<byte[]> vector = new Vector<byte[]>();
        Enumeration enumeration = this.tab.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((SessionId)enumeration.nextElement()).getId());
        }
        return vector.elements();
    }

    int getLifetime() {
        return this.lifetime;
    }

    public javax.net.ssl.SSLSession getSession(byte[] byArray) {
        SessionId sessionId = new SessionId(byArray);
        SSLSession sSLSession = (SSLSession)this.tab.get(sessionId);
        if (sSLSession != null) {
            if (System.currentTimeMillis() - sSLSession.getCreationTime() > (long)this.lifetime) {
                sSLSession.invalidate();
            }
            if (sSLSession.isValid()) {
                return sSLSession;
            }
            this.tab.remove(sessionId);
        }
        return null;
    }

    void setCacheLimit(int n) {
        this.cacheLimit = n;
    }

    void setLifetime(int n) {
        this.lifetime = n;
    }

    final class SessionId {
        private byte[] id;

        SessionId(byte[] byArray) {
            this.id = byArray;
        }

        public boolean equals(Object object) {
            try {
                return Arrays.equals(this.id, ((SessionId)object).getId());
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        byte[] getId() {
            return this.id;
        }

        public int hashCode() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.id.length) {
                n ^= this.id[n3] << 8 * n2;
                if (++n2 == 4) {
                    n2 = 0;
                }
                ++n3;
            }
            return n;
        }
    }
}

