/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.SSLMac;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.ProviderException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

class TLSMac
implements SSLMac {
    private static final byte[] MASTER_SECRET = "master secret".getBytes();
    private static final byte[] KEY_EXPANSION = "key expansion".getBytes();
    private static final byte[] CLIENT_FINISHED = "client finished".getBytes();
    private static final byte[] SERVER_FINISHED = "server finished".getBytes();
    private static final byte[] CLIENT_WRITE_KEY = "client write key".getBytes();
    private static final byte[] SERVER_WRITE_KEY = "server write key".getBytes();
    private static final byte[] IV_BLOCK = "IV block".getBytes();
    private Mac md;
    private Mac md5;
    private Mac sha;
    private byte[] lengthOctets = new byte[2];
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private byte[] temp16 = new byte[16];
    private byte[] temp20 = new byte[20];

    TLSMac(String string) {
        try {
            this.md = string.endsWith("MD5") ? Mac.getInstance("HMACwithMD5") : Mac.getInstance("HMACwithSHA1");
            this.md5 = Mac.getInstance("HMACwithMD5");
            this.sha = Mac.getInstance("HMACwithSHA1");
        }
        catch (Exception exception) {
            throw new ProviderException(exception.getMessage());
        }
    }

    private byte[] P(Mac mac, byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        try {
            this.baos.reset();
            mac.init(new SecretKeySpec(byArray, n, n2, "HMAC"), null);
            int n3 = mac.getMacLength();
            byte[] byArray5 = n3 == 16 ? this.temp16 : this.temp20;
            int n4 = 0;
            while (n4 < 7) {
                if (n4 == 0) {
                    mac.update(byArray2, 0, byArray2.length);
                    mac.update(byArray3, 0, byArray3.length);
                    mac.update(byArray4, 0, byArray4.length);
                } else {
                    mac.update(byArray5, 0, n3);
                }
                mac.doFinal(byArray5, 0);
                mac.update(byArray5, 0, n3);
                mac.update(byArray2, 0, byArray2.length);
                mac.update(byArray3, 0, byArray3.length);
                mac.update(byArray4, 0, byArray4.length);
                this.baos.write(mac.doFinal());
                ++n4;
            }
            return this.baos.toByteArray();
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("Internal error: " + shortBufferException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Internal error: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException("Internal error: " + invalidKeyException.getMessage());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal error: " + iOException.getMessage());
        }
    }

    private byte[] PRF(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        int n3 = (1 + n2) / 2;
        byte[] byArray5 = this.P(this.md5, byArray, n, n3, byArray2, byArray3, byArray4);
        byte[] byArray6 = this.P(this.sha, byArray, n + n2 - n3, n3, byArray2, byArray3, byArray4);
        int n4 = 0;
        while (n4 < byArray5.length) {
            int n5 = n4;
            byArray5[n5] = (byte)(byArray5[n5] ^ byArray6[n4]);
            ++n4;
        }
        return byArray5;
    }

    public byte[] computeHashes(MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray, boolean bl) {
        try {
            MessageDigest messageDigest3 = (MessageDigest)messageDigest.clone();
            MessageDigest messageDigest4 = (MessageDigest)messageDigest2.clone();
            byte[] byArray2 = bl ? CLIENT_FINISHED : SERVER_FINISHED;
            byte[] byArray3 = this.PRF(byArray, 0, byArray.length, byArray2, messageDigest4.digest(), messageDigest3.digest());
            byte[] byArray4 = new byte[12];
            System.arraycopy(byArray3, 0, byArray4, 0, 12);
            return byArray4;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error: " + cloneNotSupportedException.getMessage());
        }
    }

    public byte[] computeKeyBlock(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (Debug.debug >= 3) {
            com.dstc.security.util.Debug.debug("cRandom: ", byArray2);
            com.dstc.security.util.Debug.debug("sRandom: ", byArray3);
            com.dstc.security.util.Debug.debug("masterSecret: ", byArray);
        }
        return this.PRF(byArray, 0, byArray.length, KEY_EXPANSION, byArray3, byArray2);
    }

    public byte[] computeMasterSecret(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (Debug.debug >= 3) {
            com.dstc.security.util.Debug.debug("cRandom: ", byArray2);
            com.dstc.security.util.Debug.debug("sRandom: ", byArray3);
        }
        byte[] byArray4 = new byte[48];
        byte[] byArray5 = this.PRF(byArray, 0, byArray.length, MASTER_SECRET, byArray2, byArray3);
        System.arraycopy(byArray5, 0, byArray4, 0, 48);
        return byArray4;
    }

    public byte[] exportableIV(int n, byte[] byArray, byte[] byArray2, int n2) {
        byte[] byArray3 = this.PRF(new byte[0], 0, 0, IV_BLOCK, byArray, byArray2);
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray3, n * n2, byArray4, 0, n2);
        return byArray4;
    }

    public byte[] exportableKey(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        if (n == 0) {
            return this.PRF(byArray3, n2, n3, CLIENT_WRITE_KEY, byArray, byArray2);
        }
        return this.PRF(byArray3, n2, n3, SERVER_WRITE_KEY, byArray, byArray2);
    }

    public int getMacSize() {
        return this.md.getMacLength();
    }

    public byte[] macMessage(byte[] byArray, byte[] byArray2, byte by, byte[] byArray3, int n, int n2, byte[] byArray4) {
        try {
            this.md.init(new SecretKeySpec(byArray, "HMAC"), null);
            this.md.update(byArray2, 0, byArray2.length);
            this.md.update(by);
            this.md.update(byArray4, 0, byArray4.length);
            this.lengthOctets[0] = (byte)(n2 >> 8 & 0xFF);
            this.lengthOctets[1] = (byte)(n2 & 0xFF);
            this.md.update(this.lengthOctets, 0, this.lengthOctets.length);
            this.md.update(byArray3, n, n2);
            return this.md.doFinal();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException("Internal error: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException("Internal error: " + invalidKeyException.getMessage());
        }
    }

    public byte[] toBeSignedCV(String string, MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray) {
        try {
            MessageDigest messageDigest3 = (MessageDigest)messageDigest.clone();
            byte[] byArray2 = messageDigest3.digest();
            if (!string.equals("RSA")) {
                return byArray2;
            }
            MessageDigest messageDigest4 = (MessageDigest)messageDigest2.clone();
            byte[] byArray3 = messageDigest4.digest();
            byte[] byArray4 = new byte[36];
            System.arraycopy(byArray3, 0, byArray4, 0, 16);
            System.arraycopy(byArray2, 0, byArray4, 16, 20);
            return byArray4;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error: " + cloneNotSupportedException.getMessage());
        }
    }
}

