/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;

class X509CertImpl
extends X509Certificate {
    private java.security.cert.X509Certificate cert;
    private static CertificateFactory certFact;

    static {
        try {
            certFact = CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.getMessage());
        }
    }

    private X509CertImpl(java.security.cert.X509Certificate x509Certificate) {
        this.cert = x509Certificate;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        try {
            this.cert.checkValidity();
        }
        catch (java.security.cert.CertificateNotYetValidException certificateNotYetValidException) {
            throw new CertificateNotYetValidException(certificateNotYetValidException.getMessage());
        }
        catch (java.security.cert.CertificateExpiredException certificateExpiredException) {
            throw new CertificateExpiredException(certificateExpiredException.getMessage());
        }
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        try {
            this.cert.checkValidity(date);
        }
        catch (java.security.cert.CertificateNotYetValidException certificateNotYetValidException) {
            throw new CertificateNotYetValidException(certificateNotYetValidException.getMessage());
        }
        catch (java.security.cert.CertificateExpiredException certificateExpiredException) {
            throw new CertificateExpiredException(certificateExpiredException.getMessage());
        }
    }

    public boolean equals(Object object) {
        return this.cert.equals(object);
    }

    public static X509Certificate getCert(InputStream inputStream) throws CertificateException {
        try {
            return new X509CertImpl((java.security.cert.X509Certificate)certFact.generateCertificate(inputStream));
        }
        catch (Exception exception) {
            throw new CertificateException(exception.getMessage());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.cert.getEncoded();
        }
        catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
            throw new CertificateEncodingException(certificateEncodingException.getMessage());
        }
    }

    public Principal getIssuerDN() {
        return this.cert.getIssuerDN();
    }

    public Date getNotAfter() {
        return this.cert.getNotAfter();
    }

    public Date getNotBefore() {
        return this.cert.getNotBefore();
    }

    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    public BigInteger getSerialNumber() {
        return this.cert.getSerialNumber();
    }

    public String getSigAlgName() {
        return this.cert.getSigAlgName();
    }

    public String getSigAlgOID() {
        return this.cert.getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this.cert.getSigAlgParams();
    }

    public Principal getSubjectDN() {
        return this.cert.getSubjectDN();
    }

    public int getVersion() {
        return this.cert.getVersion() - 1;
    }

    public int hashCode() {
        return this.cert.hashCode();
    }

    public String toString() {
        return this.cert.toString();
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.cert.verify(publicKey);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new CertificateException(certificateException.getMessage());
        }
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.cert.verify(publicKey, string);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new CertificateException(certificateException.getMessage());
        }
    }
}

