/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Set;
import com.dstc.security.cms.Attribute;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;

class AttributeImpl
implements Attribute {
    private Asn1 asn1 = null;
    protected String type;
    protected Set values;

    AttributeImpl() {
    }

    AttributeImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.type = ((Oid)iterator.next()).getOid();
        this.values = (Set)iterator.next();
    }

    AttributeImpl(String string, Asn1 asn1) {
        this.asn1 = new Sequence();
        this.type = string;
        this.asn1.add(new Oid(string));
        this.values = new Set();
        this.values.add(asn1);
        this.asn1.add(this.values);
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getEncodedValues() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.values.writeValue(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getOid() {
        return this.type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Attribute type: ").append(this.type);
        return stringBuffer.toString();
    }
}

