/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import java.io.IOException;
import java.io.InputStream;

final class BEREncodedInputStream
extends InputStream {
    private Asn1 asn1 = null;
    private byte[] readBuffer = new byte[1];
    private byte[] buffer = null;
    private int bufLen = 0;
    private int bufOff = 0;

    BEREncodedInputStream(Asn1 asn1) {
        this.asn1 = asn1;
    }

    public int available() throws IOException {
        try {
            if (this.bufLen > 0) {
                return this.bufLen;
            }
            this.buffer = this.asn1.berEncode();
            if (this.buffer == null) {
                return 0;
            }
            return this.buffer.length;
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException("Internal error: " + asn1Exception.getMessage());
        }
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        int n = this.read(this.readBuffer);
        if (n == -1) {
            return n;
        }
        return this.readBuffer[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this.bufLen > 0) {
                int n3 = 0;
                if (this.bufLen >= n2) {
                    System.arraycopy(this.buffer, this.bufOff, byArray, n, n2);
                    n3 = n2;
                    this.bufOff += n2;
                    this.bufLen -= n2;
                } else {
                    System.arraycopy(this.buffer, this.bufOff, byArray, n, this.bufLen);
                    n3 = this.bufLen;
                    this.bufLen = 0;
                }
                return n3;
            }
            this.buffer = this.asn1.berEncode();
            if (this.buffer == null) {
                return -1;
            }
            this.bufLen = this.buffer.length;
            this.bufOff = 0;
            return this.read(byArray, n, n2);
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException("Internal error: " + asn1Exception.getMessage());
        }
    }
}

