/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.CMSTypedDataInputStream;
import com.dstc.security.cms.SignedData;
import com.dstc.security.cms.SignedDataImpl;
import com.dstc.security.cms.TwoInputStream;
import com.dstc.security.cms.VerificationResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class CMSSignature {
    private static final int UNINITIALIZED = 0;
    private static final int SIGN_MODE = 1;
    private static final int VERIFY_MODE = 2;
    private int state;
    private Vector trustedCerts;
    private Vector certStore;
    private PrivateKey priv;
    private X509Certificate[] certChain;
    private String digestAlg;
    private boolean encapContent;
    private InputStream src;
    private CMSTypedDataInputStream sigSrc;
    private InputStream msg;
    private byte[] buf = new byte[128];
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private boolean delayVerify = false;

    public CMSSignature() {
        String string = System.getProperty("jcsi.cms.delayverify");
        if (string != null && string.equals("true")) {
            this.delayVerify = true;
        }
    }

    private void forceVerify(TwoInputStream twoInputStream) throws CMSException {
        try {
            int n;
            this.baos.reset();
            while ((n = twoInputStream.read(this.buf)) != -1) {
                this.baos.write(this.buf, 0, n);
            }
            twoInputStream.setSecondStream(new ByteArrayInputStream(this.baos.toByteArray()));
        }
        catch (IOException iOException) {
            throw new CMSException("Verification error: nested exception is " + iOException.toString());
        }
    }

    public void initSign(PrivateKey privateKey, X509Certificate[] x509CertificateArray, String string) throws CMSException {
        if (privateKey == null) {
            throw new CMSException("Cannot sign with a null key");
        }
        if (!privateKey.getAlgorithm().equals("DSA") && !privateKey.getAlgorithm().equals("RSA")) {
            throw new CMSException("Cannot sign with key algorithm: " + privateKey.getAlgorithm());
        }
        if (string == null) {
            throw new CMSException("Cannot sign with a null digest algorithm");
        }
        if (!string.equals("MD5") && !string.startsWith("SHA")) {
            throw new CMSException("Digest algorithm " + string + " not supported in CMS");
        }
        this.state = 1;
        this.priv = privateKey;
        this.certChain = x509CertificateArray;
        this.digestAlg = string;
    }

    public void initVerify(Vector vector, Vector vector2) throws CMSException {
        this.state = 2;
        if (vector == null) {
            throw new CMSException("Trusted certs cannot be null");
        }
        this.trustedCerts = vector;
        this.certStore = vector2;
    }

    public void setDataToBeSigned(CMSTypedDataInputStream cMSTypedDataInputStream, boolean bl) throws CMSException {
        if (this.state != 1) {
            throw new CMSException("Not initialized for signing");
        }
        this.sigSrc = cMSTypedDataInputStream;
        this.encapContent = bl;
    }

    public void setDataToBeVerified(InputStream inputStream) throws CMSException {
        if (this.state != 2) {
            throw new CMSException("Not initialized for verification");
        }
        this.src = inputStream;
        this.msg = null;
    }

    public void setDataToBeVerified(InputStream inputStream, InputStream inputStream2) throws CMSException {
        if (this.state != 2) {
            throw new CMSException("Not initialized for verification");
        }
        this.src = inputStream;
        this.msg = inputStream2;
    }

    public CMSTypedDataInputStream sign() throws CMSException, IOException {
        if (this.state != 1) {
            throw new CMSException("Not initialized for signing");
        }
        if (this.sigSrc == null) {
            throw new CMSException("Data to be signed not yet set");
        }
        SignedDataImpl signedDataImpl = null;
        signedDataImpl = new SignedDataImpl(this.priv, this.certChain, this.digestAlg, this.encapContent, this.sigSrc);
        this.sigSrc = null;
        return signedDataImpl.getSigned();
    }

    public VerificationResult verify() throws CMSException, IOException {
        if (this.state != 2) {
            throw new CMSException("Not initialized for verification");
        }
        if (this.src == null) {
            throw new CMSException("Data to be verified not yet set");
        }
        SignedDataImpl signedDataImpl = null;
        try {
            signedDataImpl = new SignedDataImpl(this.src, this.certStore, this.trustedCerts, this.msg);
        }
        catch (Asn1Exception asn1Exception) {
            throw new CMSException("Bad encoding: " + asn1Exception.getMessage());
        }
        catch (CMSException cMSException) {
            throw cMSException;
        }
        catch (Exception exception) {
            throw new CMSException("Verification error: nested exception is " + exception.toString());
        }
        this.src = null;
        this.msg = null;
        if (!this.delayVerify) {
            this.forceVerify(signedDataImpl.getVerified());
        }
        return new VerResult(signedDataImpl.getVerified(), signedDataImpl);
    }

    class VerResult
    implements VerificationResult {
        private CMSTypedDataInputStream in;
        private SignedDataImpl sd;
        private TwoInputStream underlying;

        VerResult(TwoInputStream twoInputStream, SignedDataImpl signedDataImpl) {
            this.underlying = twoInputStream;
            this.in = new CMSTypedDataInputStream(signedDataImpl.getEncapsulatedContentType(), this.underlying);
            this.sd = signedDataImpl;
        }

        public SignedData getCMSSignedData() throws CMSException {
            if (!this.sd.isVerified()) {
                CMSSignature.this.forceVerify(this.underlying);
            }
            return this.sd;
        }

        public CMSTypedDataInputStream getVerified() {
            return this.in;
        }
    }
}

