/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Set;
import com.dstc.security.cms.AttributeImpl;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.atts.ContentType;
import java.util.Iterator;

final class ContentTypeImpl
extends AttributeImpl
implements ContentType {
    private String contentType;

    ContentTypeImpl(String string) {
        super("1.2.840.113549.1.9.3", new Oid(string));
    }

    ContentTypeImpl(String string, Set set) throws CMSException {
        this.type = string;
        this.values = set;
        Iterator iterator = set.components();
        Asn1 asn1 = (Asn1)iterator.next();
        if (asn1 == null) {
            throw new CMSException("Signing time cannot be empty");
        }
        if (!(asn1 instanceof Oid)) {
            throw new CMSException("Badly encoded signing time");
        }
        this.contentType = ((Oid)asn1).getOid();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Content type: ").append(this.contentType);
        return stringBuffer.toString();
    }
}

