/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.cms.SignedDataImpl;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

class DigestsInputStream
extends FilterInputStream {
    private MessageDigest[] digests;
    private SignedDataImpl sd = null;
    private boolean done = false;

    DigestsInputStream(SignedDataImpl signedDataImpl, InputStream inputStream, String[] stringArray) {
        super(inputStream);
        this.sd = signedDataImpl;
        this.digests = new MessageDigest[stringArray.length];
        try {
            int n = 0;
            while (n < stringArray.length) {
                this.digests[n] = MessageDigest.getInstance(stringArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.getMessage());
        }
    }

    public void close() throws IOException {
        super.close();
    }

    byte[] getDigest(String string) {
        int n = 0;
        while (n < this.digests.length) {
            if (this.digests[n].getAlgorithm().equals(string)) {
                return this.digests[n].digest();
            }
            ++n;
        }
        return null;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1 && !this.done) {
            this.verifyAll();
        } else {
            int n2 = 0;
            while (n2 < this.digests.length) {
                this.digests[n2].update((byte)n);
                ++n2;
            }
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1 && !this.done) {
            this.verifyAll();
        } else {
            int n4 = 0;
            while (n4 < this.digests.length) {
                this.digests[n4].update(byArray, n, n3);
                ++n4;
            }
        }
        return n3;
    }

    private void verifyAll() throws IOException {
        try {
            this.sd.verifyAllSigners();
            this.done = true;
        }
        catch (Exception exception) {
            throw new IOException("Verification error: nested exception is " + exception.toString());
        }
    }
}

