/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.ContentInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

final class EncapContentInfo {
    private Asn1 asn1 = null;
    private Oid eContentType;
    private byte[] eContent = null;
    private OctetString inner = null;

    EncapContentInfo(Asn1 asn1) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.eContentType = (Oid)iterator.next();
        if (!iterator.hasNext()) {
            return;
        }
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12 == null) {
            return;
        }
        this.inner = (OctetString)asn12.components().next();
    }

    EncapContentInfo(Asn1 asn1, OutputStream outputStream) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.eContentType = (Oid)iterator.next();
        if (!iterator.hasNext()) {
            return;
        }
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12 == null) {
            return;
        }
        this.inner = (OctetString)asn12.components().next();
        if (this.inner != null) {
            this.inner.writeValue(outputStream);
        }
    }

    EncapContentInfo(String string, InputStream inputStream) {
        this.asn1 = new Sequence();
        this.eContentType = new Oid(string);
        this.asn1.add(this.eContentType);
        if (inputStream == null) {
            return;
        }
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new OctetString(inputStream));
        this.asn1.add(explicit);
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    InputStream getContent() {
        if (this.inner == null) {
            return null;
        }
        return new ContentInputStream(this.inner);
    }

    String getContentType() {
        return this.eContentType.getOid();
    }

    boolean hasContent() {
        return this.inner != null;
    }
}

