/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Set;
import com.dstc.security.cms.Attribute;
import com.dstc.security.cms.BEREncodedInputStream;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.CMSTypedDataInputStream;
import com.dstc.security.cms.EncryptedContentInfo;
import com.dstc.security.cms.EnvelopedData;
import com.dstc.security.cms.Factory;
import com.dstc.security.cms.IssuerAndSerialNumber;
import com.dstc.security.cms.IssuerAndSerialNumberImpl;
import com.dstc.security.cms.KeyAgreeRecipientIdentifier;
import com.dstc.security.cms.KeyAgreeRecipientInfo;
import com.dstc.security.cms.KeyAgreeRecipientInfoImpl;
import com.dstc.security.cms.KeyTransRecipientInfo;
import com.dstc.security.cms.KeyTransRecipientInfoImpl;
import com.dstc.security.cms.OriginatorInfo;
import com.dstc.security.cms.OriginatorInfoImpl;
import com.dstc.security.cms.RecipientEncryptedKey;
import com.dstc.security.cms.RecipientIdentifier;
import com.dstc.security.cms.RecipientInfo;
import com.dstc.security.cms.RecipientKeyIdentifier;
import com.dstc.security.cms.SubjectKeyIdentifier;
import com.dstc.security.cms.SubjectKeyIdentifierImpl;
import com.dstc.security.cms.crypto.ContentKeyDecryptor;
import com.dstc.security.x509.X509ExtensionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

class EnvelopedDataImpl
implements EnvelopedData {
    private Asn1 outer = null;
    private int version = 0;
    private Vector recipients;
    private RecipientInfo matchedRcpt;
    private OriginatorInfoImpl originator;
    private EncryptedContentInfo encryptedContentInfo;
    private SecureRandom rand;
    private int contentType = 0;

    EnvelopedDataImpl(InputStream inputStream, PrivateKey privateKey, X509Certificate x509Certificate, Vector vector) throws Asn1Exception, IOException, CertificateException, CMSException {
        if (privateKey == null) {
            throw new CMSException("PrivateKey not set for decryption");
        }
        if (x509Certificate == null) {
            throw new CMSException("Cert not set for decryption");
        }
        this.decode(Asn1.getAsn1(inputStream), privateKey, x509Certificate, vector);
    }

    EnvelopedDataImpl(SecureRandom secureRandom, String string, X509Certificate[] x509CertificateArray, CMSTypedDataInputStream cMSTypedDataInputStream) throws CMSException {
        this.rand = secureRandom;
        this.outer = new Sequence();
        this.outer.add(new Oid("1.2.840.113549.1.7.3"));
        Sequence sequence = new Sequence();
        try {
            Object object;
            Object object2;
            KeyGenerator keyGenerator = null;
            SecretKey secretKey = null;
            Cipher cipher = null;
            RC2ParameterSpec rC2ParameterSpec = null;
            byte[] byArray = new byte[8];
            secureRandom.nextBytes(byArray);
            if (string.equals("DESede")) {
                keyGenerator = KeyGenerator.getInstance("DESede");
                cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                keyGenerator.init(168, secureRandom);
                secretKey = keyGenerator.generateKey();
                cipher.init(1, (Key)secretKey, new IvParameterSpec(byArray), secureRandom);
            } else if (string.equals("RC2")) {
                keyGenerator = KeyGenerator.getInstance("RC2");
                cipher = Cipher.getInstance("RC2/CBC/PKCS5Padding");
                keyGenerator.init(128, secureRandom);
                secretKey = keyGenerator.generateKey();
                rC2ParameterSpec = new RC2ParameterSpec(128, byArray);
                cipher.init(1, (Key)secretKey, rC2ParameterSpec, secureRandom);
            } else if (string.equals("RC2/40")) {
                keyGenerator = KeyGenerator.getInstance("RC2");
                cipher = Cipher.getInstance("RC2/CBC/PKCS5Padding");
                keyGenerator.init(40, secureRandom);
                secretKey = keyGenerator.generateKey();
                rC2ParameterSpec = new RC2ParameterSpec(40, byArray);
                cipher.init(1, (Key)secretKey, rC2ParameterSpec, secureRandom);
            } else {
                throw new CMSException("Unsupported algorithm " + string + " for CMS");
            }
            Set set = new Set();
            int n = 0;
            while (n < x509CertificateArray.length) {
                Object object3;
                object2 = x509CertificateArray[n].getPublicKey();
                if (object2 instanceof RSAPublicKey) {
                    if (!X509ExtensionUtil.isKeyUsageEncryption(x509CertificateArray[n])) {
                        throw new CMSException("Certificate key usage does not include encryption");
                    }
                    object = new KeyTransRecipientInfoImpl(secureRandom, x509CertificateArray[n], secretKey);
                    object3 = ((KeyTransRecipientInfoImpl)object).getAsn1();
                    set.add((Asn1)object3);
                } else if (object2 instanceof DHPublicKey) {
                    object = ((DHPublicKey)object2).getParams();
                    object3 = new Vector<X509Certificate>();
                    ((Vector)object3).add(x509CertificateArray[n]);
                    KeyAgreeRecipientInfoImpl keyAgreeRecipientInfoImpl = new KeyAgreeRecipientInfoImpl(secureRandom, (DHParameterSpec)object, (Vector)object3, secretKey);
                    Asn1 asn1 = keyAgreeRecipientInfoImpl.getAsn1();
                    asn1.setTagClass(128);
                    asn1.setTagNumber(1);
                    set.add(asn1);
                    this.version = 2;
                } else {
                    throw new CMSException("Key: " + object2 + " unsuitable for enveloped data");
                }
                ++n;
            }
            sequence.add(new Integer(this.version));
            sequence.add(set);
            object2 = new EncryptedContentInfo(cMSTypedDataInputStream.getContentType(), cMSTypedDataInputStream, cipher);
            sequence.add(((EncryptedContentInfo)object2).getAsn1());
            object = new Explicit(128, 0);
            ((Asn1)object).add(sequence);
            this.outer.add((Asn1)object);
        }
        catch (CMSException cMSException) {
            throw cMSException;
        }
        catch (Exception exception) {
            throw new CMSException("encryption error: nested exception is" + exception.toString());
        }
    }

    private void decode(Asn1 asn1, PrivateKey privateKey, X509Certificate x509Certificate, Vector vector) throws Asn1Exception, IOException, CertificateException, CMSException {
        Object object;
        Object object2;
        this.outer = asn1;
        Iterator iterator = asn1.components();
        if (!((Oid)iterator.next()).getOid().equals("1.2.840.113549.1.7.3")) {
            throw new CMSException("Not an EnvelopedData encoding");
        }
        Asn1 asn12 = (Asn1)((Asn1)iterator.next()).components().next();
        Iterator iterator2 = asn12.components();
        this.version = ((Integer)iterator2.next()).getInt();
        Asn1 asn13 = (Asn1)iterator2.next();
        if (asn13.getTagNumber() == 0) {
            this.originator = new OriginatorInfoImpl(asn13);
            asn13 = (Asn1)iterator2.next();
        }
        this.recipients = new Vector();
        Set set = (Set)asn13;
        Iterator iterator3 = set.components();
        while (iterator3.hasNext()) {
            object2 = (Asn1)iterator3.next();
            if (object2 == null) break;
            object = Factory.getRecipientInfo((Asn1)object2, vector);
            this.recipients.add(object);
            if (this.matchedRcpt != null || !EnvelopedDataImpl.match((RecipientInfo)object, x509Certificate)) continue;
            this.matchedRcpt = object;
        }
        if (this.matchedRcpt == null) {
            throw new CMSException("cannot match recipientinfo");
        }
        object2 = ContentKeyDecryptor.decryptKey(this.matchedRcpt, privateKey);
        this.encryptedContentInfo = new EncryptedContentInfo((Asn1)iterator2.next(), (byte[])object2);
        object = this.encryptedContentInfo.getContentType();
        if (((String)object).equals("1.2.840.113549.1.7.1")) {
            this.contentType = 0;
        } else if (((String)object).equals("1.2.840.113549.1.7.2")) {
            this.contentType = 1;
        } else if (((String)object).equals("1.2.840.113549.1.7.3")) {
            this.contentType = 2;
        } else {
            throw new CMSException("Content type " + (String)object + " unsupported for CMS encryption");
        }
    }

    public int getCMSVersion() {
        return this.version;
    }

    InputStream getDecrypted() {
        return this.encryptedContentInfo.getDecrypted();
    }

    CMSTypedDataInputStream getEncrypted() {
        return new CMSTypedDataInputStream(2, new BEREncodedInputStream(this.outer));
    }

    int getEncryptedContentType() {
        return this.contentType;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originator;
    }

    public RecipientInfo[] getRecipientInfos() {
        if (this.recipients == null) {
            return null;
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[this.recipients.size()];
        this.recipients.toArray(recipientInfoArray);
        return recipientInfoArray;
    }

    public Attribute[] getUnprotectedAttributes() {
        return null;
    }

    private static boolean match(RecipientEncryptedKey recipientEncryptedKey, X509Certificate x509Certificate) {
        KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = recipientEncryptedKey.getRecipientId();
        if (keyAgreeRecipientIdentifier instanceof IssuerAndSerialNumber) {
            return new IssuerAndSerialNumberImpl(x509Certificate).equals(keyAgreeRecipientIdentifier);
        }
        if (keyAgreeRecipientIdentifier instanceof RecipientKeyIdentifier) {
            return new IssuerAndSerialNumberImpl(x509Certificate).equals(((RecipientKeyIdentifier)keyAgreeRecipientIdentifier).getSubjectKeyIdentifier());
        }
        return false;
    }

    private static boolean match(RecipientInfo recipientInfo, X509Certificate x509Certificate) {
        if (recipientInfo instanceof KeyTransRecipientInfo) {
            RecipientIdentifier recipientIdentifier = ((KeyTransRecipientInfo)recipientInfo).getRecipientIdentifier();
            if (recipientIdentifier instanceof IssuerAndSerialNumber) {
                return new IssuerAndSerialNumberImpl(x509Certificate).equals(recipientIdentifier);
            }
            if (recipientIdentifier instanceof SubjectKeyIdentifier) {
                return new SubjectKeyIdentifierImpl(x509Certificate).equals(recipientIdentifier);
            }
            return false;
        }
        Vector vector = ((KeyAgreeRecipientInfo)recipientInfo).getRecipientEncryptedKeys();
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            if (!EnvelopedDataImpl.match((RecipientEncryptedKey)iterator.next(), x509Certificate)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("EnvelopedData");
        stringBuffer.append("\n[");
        stringBuffer.append("\n  version: ").append(this.version);
        if (this.originator != null) {
            stringBuffer.append("\noriginatorInfo: " + this.originator);
        }
        if (this.recipients == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append("\n  RecipientInfos ");
        stringBuffer.append("{no of recipients = ");
        stringBuffer.append(String.valueOf(this.recipients.size()));
        stringBuffer.append("}");
        stringBuffer.append("\n  [");
        int n = 0;
        while (n < this.recipients.size()) {
            StringTokenizer stringTokenizer = new StringTokenizer(((RecipientInfo)this.recipients.elementAt(n)).toString(), "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("\n     ").append(stringTokenizer.nextToken());
            }
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("  ]");
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

