/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.IssuerAndSerialNumberImpl;
import com.dstc.security.cms.KeyAgreeRecipientIdentifier;
import com.dstc.security.cms.KeyAgreeRecipientInfoImpl;
import com.dstc.security.cms.KeyTransRecipientInfoImpl;
import com.dstc.security.cms.OriginatorIdentifierOrKey;
import com.dstc.security.cms.OriginatorPublicKeyImpl;
import com.dstc.security.cms.RecipientIdentifier;
import com.dstc.security.cms.RecipientInfo;
import com.dstc.security.cms.RecipientKeyIdentifierImpl;
import com.dstc.security.cms.SignerIdentifier;
import com.dstc.security.cms.SubjectKeyIdentifierImpl;
import java.util.Vector;

class Factory {
    Factory() {
    }

    static KeyAgreeRecipientIdentifier getKeyAgreeRecipientIdentifier(Asn1 asn1) throws Asn1Exception {
        KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = null;
        keyAgreeRecipientIdentifier = asn1.getTagNumber() == 0 ? new RecipientKeyIdentifierImpl(asn1.getValue()) : new IssuerAndSerialNumberImpl(asn1);
        return keyAgreeRecipientIdentifier;
    }

    static OriginatorIdentifierOrKey getOriginatorIdentifierOrKey(Asn1 asn1) throws Asn1Exception {
        OriginatorIdentifierOrKey originatorIdentifierOrKey = null;
        originatorIdentifierOrKey = asn1.getTagNumber() == 0 ? new SubjectKeyIdentifierImpl(asn1.getValue()) : (asn1.getTagNumber() == 1 ? new OriginatorPublicKeyImpl(asn1) : new IssuerAndSerialNumberImpl(asn1));
        return originatorIdentifierOrKey;
    }

    static RecipientIdentifier getRecipientIdentifier(Asn1 asn1) throws Asn1Exception {
        SignerIdentifier signerIdentifier = null;
        signerIdentifier = asn1.getTagNumber() != 0 ? new IssuerAndSerialNumberImpl(asn1) : new SubjectKeyIdentifierImpl(asn1.getValue());
        return signerIdentifier;
    }

    static RecipientInfo getRecipientInfo(Asn1 asn1, Vector vector) throws Asn1Exception, CMSException {
        RecipientInfo recipientInfo = null;
        recipientInfo = asn1.getTagNumber() == 1 ? new KeyAgreeRecipientInfoImpl(asn1, vector) : new KeyTransRecipientInfoImpl(asn1);
        return recipientInfo;
    }

    static SignerIdentifier getSignerIdentifier(Asn1 asn1) throws Asn1Exception {
        SignerIdentifier signerIdentifier = null;
        signerIdentifier = asn1.getTagNumber() != 0 ? new IssuerAndSerialNumberImpl(asn1) : new SubjectKeyIdentifierImpl(asn1.getValue());
        return signerIdentifier;
    }
}

