/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.IssuerAndSerialNumber;
import com.dstc.security.common.X500Name;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Iterator;

final class IssuerAndSerialNumberImpl
extends IssuerAndSerialNumber {
    private Asn1 asn1 = null;
    private X500Name issuer;
    private BigInteger serialNumber;

    IssuerAndSerialNumberImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.issuer = new X500Name((Asn1)iterator.next());
        this.serialNumber = ((Integer)iterator.next()).getBigInteger();
    }

    IssuerAndSerialNumberImpl(X509Certificate x509Certificate) {
        this.issuer = new X500Name(x509Certificate.getIssuerDN().getName());
        if (this.issuer != null) {
            this.asn1 = new Sequence();
            this.asn1.add(this.issuer.getAsn1());
            this.serialNumber = x509Certificate.getSerialNumber();
            this.asn1.add(new Integer(this.serialNumber));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof IssuerAndSerialNumber) {
            BigInteger bigInteger = ((IssuerAndSerialNumber)object).getSerialNumber();
            String string = ((IssuerAndSerialNumber)object).getIssuer();
            if (this.getSerialNumber() == null || this.getIssuer() == null || bigInteger == null || string == null) {
                return false;
            }
            return bigInteger.equals(this.getSerialNumber()) && string.equals(this.getIssuer());
        }
        return false;
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public String getIssuer() {
        if (this.issuer == null) {
            return null;
        }
        return this.issuer.getName();
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("IssuerAndSerialNumber: ");
        stringBuffer.append("\n  issuer: ").append(this.getIssuer());
        stringBuffer.append("\n  serial no: ").append(this.getSerialNumber().toString(16));
        return stringBuffer.toString();
    }
}

