/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.Factory;
import com.dstc.security.cms.IssuerAndSerialNumberImpl;
import com.dstc.security.cms.KeyAgreeRecipientInfo;
import com.dstc.security.cms.OriginatorIdentifierOrKey;
import com.dstc.security.cms.OriginatorPublicKeyImpl;
import com.dstc.security.cms.RecipientEncryptedKeyImpl;
import com.dstc.security.cms.crypto.KeyWrap;
import com.dstc.security.cms.crypto.RC2KeyWrap;
import com.dstc.security.cms.crypto.TripleDESKeyWrap;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

final class KeyAgreeRecipientInfoImpl
implements KeyAgreeRecipientInfo {
    private Asn1 asn1 = null;
    private int version = 3;
    private OriginatorIdentifierOrKey originator;
    private String keyEncryptionAlg;
    private Vector encryptedKeys = null;
    private Vector certStore;
    private SecureRandom rand;

    KeyAgreeRecipientInfoImpl(Asn1 asn1, Vector vector) throws Asn1Exception, CMSException {
        Iterator iterator;
        this.certStore = vector;
        this.asn1 = asn1;
        Iterator iterator2 = asn1.components();
        this.version = ((Integer)iterator2.next()).getInt();
        if (this.version != 3) {
            throw new CMSException("Bad version number for KeyAgreeRecipientInfo: " + this.version);
        }
        Asn1 asn12 = (Asn1)iterator2.next();
        this.originator = Factory.getOriginatorIdentifierOrKey((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator2.next();
        if (asn12.getTagNumber() == 1) {
            asn12 = (Asn1)iterator2.next();
        }
        try {
            this.keyEncryptionAlg = OID.getAlgName(new AlgorithmId(asn12).getOid());
        }
        catch (Exception exception) {
            iterator = asn12.components();
            iterator.next();
            this.keyEncryptionAlg = OID.getAlgName(new AlgorithmId((Asn1)iterator.next()).getOid());
        }
        iterator = ((Asn1)iterator2.next()).components();
        this.encryptedKeys = new Vector();
        while (iterator.hasNext()) {
            Asn1 asn13 = (Asn1)iterator.next();
            if (asn13 == null) break;
            this.encryptedKeys.add(new RecipientEncryptedKeyImpl(asn13));
        }
    }

    KeyAgreeRecipientInfoImpl(SecureRandom secureRandom, DHParameterSpec dHParameterSpec, Vector vector, SecretKey secretKey) throws CMSException {
        try {
            this.rand = secureRandom;
            this.asn1 = new Sequence();
            this.asn1.add(new Integer(this.version));
            KeyPair keyPair = null;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
            keyPairGenerator.initialize(dHParameterSpec, secureRandom);
            keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            byte[] byArray = new Integer(((DHPublicKey)keyPair.getPublic()).getY()).getEncoded();
            OriginatorPublicKeyImpl originatorPublicKeyImpl = new OriginatorPublicKeyImpl(new AlgorithmId("1.2.840.10046.2.1"), byArray);
            Asn1 asn1 = originatorPublicKeyImpl.getAsn1();
            asn1.setTagClass(128);
            asn1.setTagNumber(1);
            Explicit explicit = new Explicit(128, 0);
            explicit.add(asn1);
            this.asn1.add(explicit);
            if (secretKey.getAlgorithm().equals("DESede")) {
                this.asn1.add(new AlgorithmId("1.2.840.113549.1.9.16.3.6").getAsn1());
            } else if (secretKey.getAlgorithm().equals("RC2")) {
                this.asn1.add(new AlgorithmId("1.2.840.113549.1.9.16.3.7").getAsn1());
            } else {
                throw new CMSException("Key algorithm " + secretKey.getAlgorithm() + "not supported in CMS");
            }
            Sequence sequence = new Sequence();
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                byte[] byArray2 = this.getWrappedKey(keyPair.getPrivate(), x509Certificate.getPublicKey(), secretKey);
                sequence.add(new RecipientEncryptedKeyImpl(new IssuerAndSerialNumberImpl(x509Certificate), byArray2).getAsn1());
            }
            this.asn1.add(sequence);
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public int getCMSVersion() {
        return this.version;
    }

    public String getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlg;
    }

    public OriginatorIdentifierOrKey getOriginatorIdentifierOrKey() {
        return this.originator;
    }

    public Vector getRecipientEncryptedKeys() {
        return this.encryptedKeys;
    }

    private byte[] getWrappedKey(PrivateKey privateKey, PublicKey publicKey, SecretKey secretKey) throws CMSException {
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance("ESDH");
            keyAgreement.init(privateKey);
            keyAgreement.doPhase(publicKey, true);
            SecretKey secretKey2 = null;
            KeyWrap keyWrap = null;
            if (secretKey.getAlgorithm().equals("DESede")) {
                secretKey2 = keyAgreement.generateSecret("3DESwrap");
                keyWrap = new TripleDESKeyWrap(this.rand);
            } else if (secretKey.getAlgorithm().equals("RC2")) {
                secretKey2 = keyAgreement.generateSecret("RC2wrap");
                keyWrap = new RC2KeyWrap(this.rand);
            }
            keyWrap.setKeyEncryptingKey(secretKey2.getEncoded());
            byte[] byArray = keyWrap.encrypt(secretKey.getEncoded());
            return byArray;
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("KeyAgreeRecipientInfo");
        stringBuffer.append("\n[");
        stringBuffer.append("\n  Version: ").append(this.version);
        stringBuffer.append("\n  OriginatorOrKey: ");
        StringTokenizer stringTokenizer = new StringTokenizer(this.originator.toString(), "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\n    ").append(stringTokenizer.nextToken());
        }
        stringBuffer.append("\n  Key encryption algo: ");
        stringBuffer.append(this.getKeyEncryptionAlgorithm());
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

