/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.OriginatorPublicKey;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import java.util.Iterator;

final class OriginatorPublicKeyImpl
extends OriginatorPublicKey {
    private Asn1 asn1 = null;
    private AlgorithmId algId;
    private byte[] publicKeyBytes;

    OriginatorPublicKeyImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.algId = new AlgorithmId((Asn1)iterator.next());
        this.publicKeyBytes = ((BitString)iterator.next()).getBytes();
    }

    OriginatorPublicKeyImpl(AlgorithmId algorithmId, byte[] byArray) {
        this.asn1 = new Sequence();
        this.algId = algorithmId;
        this.asn1.add(algorithmId.getAsn1());
        this.publicKeyBytes = byArray;
        this.asn1.add(new BitString(byArray));
    }

    public String getAlgorithm() {
        return OID.getAlgName(this.algId.getOid());
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKeyBytes;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Originator public key: ");
        stringBuffer.append("\n  key algo:").append(this.getAlgorithm());
        return stringBuffer.toString();
    }
}

