/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.Factory;
import com.dstc.security.cms.IssuerAndSerialNumberImpl;
import com.dstc.security.cms.KeyAgreeRecipientIdentifier;
import com.dstc.security.cms.RecipientEncryptedKey;
import java.util.Iterator;

final class RecipientEncryptedKeyImpl
extends RecipientEncryptedKey {
    private Asn1 asn1 = null;
    private KeyAgreeRecipientIdentifier rid = null;
    private byte[] encryptedKey = null;

    RecipientEncryptedKeyImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.rid = Factory.getKeyAgreeRecipientIdentifier((Asn1)iterator.next());
        this.encryptedKey = ((OctetString)iterator.next()).getBytes();
    }

    RecipientEncryptedKeyImpl(IssuerAndSerialNumberImpl issuerAndSerialNumberImpl, byte[] byArray) {
        this.asn1 = new Sequence();
        this.rid = issuerAndSerialNumberImpl;
        this.asn1.add(issuerAndSerialNumberImpl.getAsn1());
        this.encryptedKey = byArray;
        this.asn1.add(new OctetString(byArray));
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public KeyAgreeRecipientIdentifier getRecipientId() {
        return this.rid;
    }
}

