/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.AttributeImpl;
import com.dstc.security.common.X500Name;
import java.math.BigInteger;
import java.security.cert.X509Certificate;

final class SMIMEEncryptionKeyPreferenceImpl
extends AttributeImpl {
    public SMIMEEncryptionKeyPreferenceImpl(X509Certificate x509Certificate) {
        super("1.2.840.113549.1.9.16.2.11", SMIMEEncryptionKeyPreferenceImpl.toIssuerAndSerialNumber(x509Certificate));
    }

    private static Asn1 toIssuerAndSerialNumber(X509Certificate x509Certificate) {
        Asn1 asn1 = new Asn1();
        X500Name x500Name = new X500Name(x509Certificate.getIssuerDN().getName());
        Sequence sequence = new Sequence();
        sequence.add(x500Name.getAsn1());
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        sequence.add(new Integer(bigInteger));
        asn1.add(sequence);
        asn1.setTagClass(128);
        asn1.setTagNumber(0);
        return asn1;
    }
}

