/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Set;
import com.dstc.security.cms.AttributeFactory;
import com.dstc.security.cms.AttributeImpl;
import com.dstc.security.cms.CMSException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

final class SignedAttributes {
    private Asn1 asn1 = null;
    private Vector atts;

    SignedAttributes(Asn1 asn1) throws Asn1Exception, CMSException {
        this.asn1 = Asn1.getAsn1(asn1.getEncoded());
        this.asn1.setTagClass(0);
        this.asn1.setTagNumber(17);
        this.resolveAttributes();
    }

    public SignedAttributes(Vector vector) {
        this.asn1 = new Set();
        this.atts = vector;
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            this.asn1.add(((AttributeImpl)iterator.next()).getAsn1());
        }
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public Vector getAttributes() {
        return this.atts;
    }

    void resolveAttributes() throws Asn1Exception, CMSException {
        Iterator iterator = this.asn1.components();
        this.atts = new Vector();
        while (iterator.hasNext()) {
            Asn1 asn1 = (Asn1)iterator.next();
            if (asn1 == null) break;
            this.atts.add(AttributeFactory.createAttribute(asn1));
        }
    }
}

